import { fakeAsync,
        async,
        tick,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';

import { EinsuranceHomeComponent } from './einsurance-home.component';

import { ActiveState } from '../../core/activestate/activestate.service'

describe('EinsuranceHomeComponent', () => {
  let component: EinsuranceHomeComponent
  let fixture: ComponentFixture<EinsuranceHomeComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EinsuranceHomeComponent
      ],
      providers: [ActiveState]
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(EinsuranceHomeComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule();
  });

  it('div 1 should have no accessibility issues', ((done) => {
    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error("AXE-CORE ERROR:"+error)
    })
  }))

  it('div 2 should have no accessibility issues', ((done) => {

    component.eInsurance = true
    fixture.detectChanges()

    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error("AXE-CORE ERROR:"+error)
    })
  }))


})
