import { fakeAsync,
        async,
        tick,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing';
import { ActiveState } from '../../core/activestate/activestate.service'

import { EadminHomeComponent } from './eadmin-home.component'

describe('EadminHomeComponent', () => {
  let component: EadminHomeComponent
  let fixture: ComponentFixture<EadminHomeComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        EadminHomeComponent
      ],
      providers: [ActiveState]
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(EadminHomeComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule();
  });

  it('should have no accessibility issues', ((done) => {
    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error("AXE-CORE ERROR:"+error)
    })
  }))
})
