import { ElementRef, HostListener, Component, Input, OnInit } from '@angular/core'
import { Router, ActivatedRoute } from '@angular/router'
import { Observable } from 'rxjs/Observable'

import { SearchApiService } from '../../core/search/search-api.service'

@Component({
  selector: 'app-search-results',
  templateUrl: './search-results.component.html',
  styleUrls: ['./search-results.component.css']
})
export class SearchResultsComponent implements OnInit {
  results: Array<any>
  type: string
  q: string

  constructor(
    private eRef: ElementRef,
    private route: ActivatedRoute,
    public searchApiService: SearchApiService) {
  }

  search() {
    return new Promise((resolve, reject) => {
      // console.log(`search|q:${this.q}|type:${this.type}`)
      this.searchApiService
        .search({
          datasource: this.type,
          q: this.q.split(' ')[0],
          filterProperty: this.type === 'contacts' ? 'name' : 'text'
        })
        .subscribe(p => {
          let items = p.items
          //+ searches with spaces become literal
          if (this.q.indexOf(' ') > -1) {
            items = items.filter(p => JSON.stringify(p).indexOf(this.q) > -1)
          }
          this.results = items
          resolve()
        })
    })
  }

  ngOnInit() {
    if (typeof this.route === 'undefined' || typeof this.route.queryParams === 'undefined') {
      return
    }
    this.route.queryParams.subscribe(queryParams => {
      this.q = queryParams['q'] || ''
      this.type = queryParams['type'] || ''
      // console.log(`route update|q:${this.q}|type:${this.type}`)
      if (this.q.length === 0 || this.type.length === 0) {
        return
      }
      this.search()
    })
  }
}
