import { fakeAsync, inject, async, tick, ComponentFixture, TestBed } from '@angular/core/testing'
import { ActivatedRoute } from '@angular/router'
import { By } from '@angular/platform-browser'
import { DebugElement } from '@angular/core'
import { FormsModule } from '@angular/forms'
import { RouterTestingModule } from '@angular/router/testing'

import { LocalConfig } from '../../core/config/local-config'
import { HttpModule, Http, BaseRequestOptions, XHRBackend } from '@angular/http'
import { MockBackend } from '@angular/http/testing'

import { SearchResultsComponent } from './search-results.component'
import { ConfigApiService } from '../../core/config/config-api.service'
import { ConfigService } from '../../core/config/config.service'
import { SearchApiService } from '../../core/search/search-api.service'
import { SearchApiServiceStub } from '../../core/search/search-api.service.stub'

import { PagedEntry } from '../../core/search/paged-entry'
import { Aggregate } from '../../core/search/aggregate'

describe('SearchResultsComponent', () => {
  let component: SearchResultsComponent
  let fixture: ComponentFixture<SearchResultsComponent>

  beforeEach(async(() => {
    LocalConfig.DataProvider = "memory"
    TestBed.configureTestingModule({
      imports: [
        FormsModule,
        HttpModule,
        RouterTestingModule
      ],
      declarations: [
        SearchResultsComponent
      ],
      providers: [{
        provide: Http, useFactory: (backend, options) => {
          return new Http(backend, options)
        },
        deps: [MockBackend, BaseRequestOptions]
      },
      // {
      //   provide: ActivatedRoute,
      //   useValue: {
      //     queryParams: {
      //       subscribe: (fn: (value) => void) => fn({
      //         q: 'a',
      //         type: 'contacts'
      //       })
      //     }
      //   }
      // },
      { provide: SearchApiService, useClass: SearchApiServiceStub },
        MockBackend, BaseRequestOptions, ConfigService, ConfigApiService]
    })
      .compileComponents()
  }))

  beforeEach(() => {
    fixture = TestBed.createComponent(SearchResultsComponent)
    component = fixture.componentInstance
    fixture.detectChanges()
  })

  it('expects no results', (done) => {
    async(inject([SearchApiService], (async (searchApiService: SearchApiService) => {
      component.type = 'contacts'
      const filterProperty = 'name'

      component.q = 'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz'

      await component.search()
      fixture.detectChanges()

      let de: DebugElement = fixture.debugElement.query(By.css('.search-results'))
      expect(de).not.toBeNull()

      const h3 = de.query(By.css('h3'))
      expect(h3.nativeElement.innerText).toEqual('Results for ' + component.q)

      const div = de.query(By.css('div > p > span'))
      expect(div.nativeElement.innerText).toEqual('No results')

      done()
    }))())
  })

  it('expects rendered result set', (done) => {
    async(inject([SearchApiService], ((searchApiService: SearchApiService) => {
      searchApiService.stats('contacts', 'name', Aggregate.FirstLetter)
        .subscribe(async stats => {
          component.type = 'contacts'
          const filterProperty = 'name'

          //+ use letter with largest count so subsequent query size will be less than or equal to
          component.q = Object.keys(stats)[0]

          await component.search()

          const initialResults = component.results.slice(0)

          expect(initialResults.length).toBeGreaterThan(0)

          const letter = initialResults[0][filterProperty][1]
          component.q += letter

          await component.search()
          const secondResults = component.results.slice(0)

          expect(secondResults.length).toBeLessThanOrEqual(initialResults.length)

          fixture.detectChanges()

          let de: DebugElement = fixture.debugElement.query(By.css('.search-results'))
          expect(de).not.toBeNull()

          const h3 = de.query(By.css('h3'))
          expect(h3.nativeElement.innerText).toEqual('Results for ' + component.q)

          const div = de.query(By.css('.contacts-results'))
          expect(div).not.toBeNull()

          expect(div.children.length).toEqual(secondResults.length)

          done()
        })
    }))())
  })

})
