import { NgModule, ModuleWithProviders } from '@angular/core';
import { CommonModule } from '@angular/common';

import { MccfDataModule } from '../mccf-data/mccf-data.module';

import { routing } from './mccf-common.routing';
import { SpellCheckComponent } from './spellcheck/spellcheck.component';
import { AdminMenusComponent } from './admin-menus/admin-menus.component';
import { FhirSearchComponent } from './fhir-search/fhir-search.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { PractitionerComponent } from './fhir-search/practitioner/practitioner.component';
import { TreatmentFacilityComponent } from './fhir-search/treatment-facility/treatment-facility.component';
import { PatientComponent } from './fhir-search/patient/patient.component';
import { LoggerComponent } from './logger/logger.component';
import { LogTypePipe } from './logger/type.pipe';
import { NgxDatatableModule } from '@swimlane/ngx-datatable';
import { FaqComponent } from './faq/faq.component';
import { HelpComponent } from './help/help.component';
import { ContactComponent } from './contact/contact.component';
import { SearchResultsComponent } from './search-results/search-results.component'

@NgModule({
    imports: [
    CommonModule,
    MccfDataModule,
    routing,
    FormsModule,
    ReactiveFormsModule,
    NgxDatatableModule
    ],
    declarations: [
    SpellCheckComponent,
    AdminMenusComponent,
    FhirSearchComponent,
    PractitionerComponent,
    TreatmentFacilityComponent,
    PatientComponent,
    LoggerComponent,
    LogTypePipe,
    FaqComponent,
    HelpComponent,
    ContactComponent,
    SearchResultsComponent
    ]
})
export class MccfCommonModule {
  static forRoot(): ModuleWithProviders {
    return {
      ngModule: CommonModule
    }
  }
}
