import { Component,
        OnInit } from '@angular/core'
import { LogLevel,
         LoggerService
       } from '../../core/logger/logger.service'
import { LoggingApiService,
         LogEntry
       } from '../../core/logger/logging-api.service'
import {PagedData} from "./model/paged-data"
import {Page} from "./model/page"

@Component({
  selector: 'logger-app',
  templateUrl: './logger.component.html'
})
export class LoggerComponent {
  page = new Page();
  rows = new Array<LogEntry>();

  constructor( private loggingApiService: LoggingApiService,
              private loggerService: LoggerService) {
      this.page.pageNumber = 0
      this.page.size = 20
  }

  ngOnInit() {
    console.log("LoggerComponent::.ctor")
    setTimeout(this.setPage({ offset: 0 }),2000)
  }

  /**
  * Populate the table with new data based on the page number
  * @param page The page to select
  */
  setPage(pageInfo) {
    this.page.pageNumber = pageInfo.offset;

    let options = { page: this.page.pageNumber+1, pageSize: this.page.size }
    this.loggingApiService.get(options)
      .subscribe(p => {
          let pagedData = new PagedData<LogEntry>();
          this.page.totalElements = p.total;
          this.page.totalPages = this.page.totalElements / this.page.size;

          for (let i = 0; i < p.items.length; i++) {
              let jsonObj = p.items[i]
              let log = new LogEntry()
              log.outcomeDesc = jsonObj.outcomeDesc
              log.type = jsonObj.type
              log.recorded = jsonObj.recorded
              pagedData.data.push(log)
          }
          this.rows = pagedData.data

      })
  }

  getRowClass(row) {
    if(row.type === "3") {
      return {'DataTableRowError': true}
    } else if(row.type === "4") {
      return {'DataTableRowWarn': true}
    } else if(row.type === "7") {
        return {'DataTableRowDebug': true}
    } else {
      return {'DataTableRowInfo': true}
    }
  }

}
