import { fakeAsync,
        async,
        ComponentFixture,
        TestBed } from '@angular/core/testing'
import * as Axe from 'axe-core'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { KarmaHelper } from '../../../../../karma/karma-helper'
import { RouterTestingModule } from '@angular/router/testing'

import { Patient } from '../../../mccf-data/fhir-data/patient'
import { Exposure } from '../../../mccf-data/fhir-data/exposure';
import { Facility } from '../../../mccf-data/fhir-data/facility';
import { Item } from '../../../mccf-data/fhir-data/item'
import { PatientComponent } from './patient.component';

describe('PatientComponent', () => {
  let component: PatientComponent
  let fixture: ComponentFixture<PatientComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule,
        RouterTestingModule.withRoutes([])
      ],
      declarations: [
        PatientComponent
      ],
      providers: []
    }).compileComponents()
      .then(()=>{
        fixture = TestBed.createComponent(PatientComponent)
      })

  }))

  beforeEach(()=>{
    component = fixture.componentInstance
    component.ngOnInit()
    fixture.detectChanges()
  })

  beforeEach(()=>{
    let pat = new Patient()
    pat.totalItems = 1
    let item = new Item()
    item.birthDate = '08/04/1978'
    item.familyName = "Chien"
    item.briefId = "123"


    let exp = new Exposure()
    exp.name = "expose name"
    exp.uid = "123"
    item.exposures.push(exp)
    let fac = new Facility()
    fac.code = "321"
    fac.latestDate = "02/02/2017"
    fac.name = "VA Hills"
    item.facility.push(fac)
    pat.items.push(item)

    component.patients.push(pat)
    fixture.detectChanges()
  })

  afterEach(function () {
    TestBed.resetTestingModule()
  });

  it('should have a patient loaded', ((done)=>{
    expect(component.patients.length).toEqual(1)
    done()
  }))

  it('should have no accessibility issues', ((done) => {
    // console.error(" @@@@@@@@@@@@@ html="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions()).then((result)=>{
      KarmaHelper.axeViolationLog(result)
      expect(result.violations.length).toEqual(0)
      done()
    }).catch((error)=>{
        console.error("AXE-CORE ERROR:"+error)
    })
  }))
})
