import { inject,
        TestBed,
        ComponentFixture,
        getTestBed,
        async,
        fakeAsync,
        tick
       } from '@angular/core/testing'
import { HttpModule} from "@angular/http"
import { ReactiveFormsModule } from '@angular/forms'
import { FhirSearchComponent } from './fhir-search.component'
import { FhirDataService } from '../../mccf-data/fhir-data/fhir-data.service'
import { PractitionerComponent } from './practitioner/practitioner.component'
import { TreatmentFacilityComponent } from './treatment-facility/treatment-facility.component'
import { PatientComponent } from './patient/patient.component'
import * as Axe from 'axe-core'
import { KarmaHelper } from '../../../../karma/karma-helper'


describe('FhirSearchComponent', () => {
  let component: FhirSearchComponent
  let fixture: ComponentFixture<FhirSearchComponent>

  beforeEach(async(() => {

    TestBed.configureTestingModule({
      imports: [
        ReactiveFormsModule,
        HttpModule
      ],
      declarations: [
        FhirSearchComponent,
        PractitionerComponent,
        TreatmentFacilityComponent,
        PatientComponent
      ],
      providers: [
        FhirDataService
      ]
    }).compileComponents()


  }))

  it('select page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                    .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    //  document.getElementsByTagName('body')[0].insertAdjacentHTML('beforeend',fixt.nativeElement)
    //  console.error(" @@@@@@@@@@@@@@@@@@@@ doc="+document.body.innerHTML)

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('Search page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.page = "search"
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('practitionerReport page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.page = "practitionerReport"
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('treatmentFacilityReport page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.page = "treatmentFacilityReport"
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('patientReport page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.page = "patientReport"
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

  it('providerReport page should have no accessibility issues', fakeAsync(() => {
    let res: Axe.AxeResults
    let fixt: ComponentFixture<FhirSearchComponent> = getTestBed()
                .createComponent(FhirSearchComponent)
    let comp = fixt.componentInstance

    comp.ngOnInit()
    fixt.detectChanges()
    comp.page = "providerReport"
    fixt.detectChanges()

    Axe.run(document, KarmaHelper.axeOptions(), (error,result) => {
      this.res = result
      if(error) {
        console.error(error)
      }
    })

    tick()
    KarmaHelper.axeViolationLog(this.res)
    expect(this.res.violations.length).toEqual(0)

  }))

})
