import { Component, OnInit, Inject } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { MenusService } from '../../core/menus/menus.service';
import { Menu } from '../../core/menus/menu';
import { ErrorService } from '../../core/error-messages/error.service';

@Component({
  selector: 'app-admin-menus',
  templateUrl: './admin-menus.component.html',
  providers: [MenusService]
})
export class AdminMenusComponent implements OnInit {
  service: MenusService;
  isMenuLoaded:boolean = false;
  errorMessage: string = '';
  menus: Menu[];
  menuForm: FormGroup;

  constructor(@Inject(MenusService) Service, private error: ErrorService) {
    this.service = Service;
  }

  ngOnInit() {
    this.service.getMenus()
                .subscribe(this.menuUpdate.bind(this));
    this.menuForm = new FormGroup({});

    this.error.setErrorCode("", "stack trace error: very long error trace and detailed information.!!!!!!!!!!!!!!!");
  }

  menuUpdate(data: any) {
    this.menus = data;
    console.log(" ADMIN MENU menus length ="+this.menus.length);
    this.isMenuLoaded = true;
  }

  update() {
    alert("This function is not implemented.")
  }

  cancel() {
    alert("This function is not implemented.")
  }

}
