import { TestBed, inject } from '@angular/core/testing';
import { MockBackend, MockConnection } from '@angular/http/testing';
import { Http, BaseRequestOptions, Response, ResponseOptions, RequestMethod } from '@angular/http';

import { MenusService } from './menus.service';

describe('MenusService', function() {
  let subject: MenusService;
  let backend: MockBackend;

  beforeEach(function() {

    TestBed.configureTestingModule({
        providers: [
          MenusService,
          MockBackend,
          BaseRequestOptions,
          {
            provide: Http,
            useFactory: function(mockBackend, defaultOptions) {
              return new Http(mockBackend, defaultOptions);
              },
            deps: [MockBackend, BaseRequestOptions]
          }
        ]
    });

  });

  beforeEach(inject([MenusService, MockBackend], function(MenusService, mockBackend) {
    subject = MenusService;
    backend = mockBackend;
  }));


  it('should get data', function(done) {

    backend.connections.subscribe(function(connection: MockConnection) {

      let options = new ResponseOptions({ body: {
                "menus": [{
                  "title":"ePayments",
                  "subMenu":[
                        {"title":"google",
                          "uri":"www.google.com"},
                        {"title":"yahoo",
                          "uri":"www.yahoo.com"},
                        {"title":"cats",
                          "uri":"www.vetstreet.com/cats/"},
                        {"title":"dogs",
                          "uri":"www.franklincountydogs.com/adopt/available.cfm"}
                            ]
                  }]
                }
       });
      connection.mockRespond(new Response(options));
    });

    subject.getMenus().subscribe(function(response) {
        expect(response).toEqual(jasmine.any(Array));
        expect(response[0].title).toEqual('ePayments');
        expect(response[0].subMenu[0].title).toEqual('google');
        expect(response[0].subMenu.length).toEqual(4);
        },
        function(e) {
          console.log(" ERROR:"+e);
        }
    );

    done();
  });

  afterEach(function() {
    TestBed.resetTestingModule();
  });



});
