import { Injectable } from '@angular/core'
import {Http, Response } from '@angular/http'
import { Observable } from 'rxjs/Rx'
import { MainContent } from './maincontent'

@Injectable()
export class MainContentService {

  private maincontent:any;

  constructor(private http:Http) {}

  getContent():Observable<MainContent> {
    return this.http.get('../../assets/config/maincontent.json').map(mapMainContent);
  }

}

function mapMainContent(response:Response): MainContent {
  let r = response.json()
  let mc = new MainContent()

  let rUrl = r["erevenueUrls"]
  for(let i=0; i< rUrl.length; i++) {
    mc.erevenueUrls.push(rUrl[i])
  }
  mc.phone = r["phone"]
  mc.emailText = r["emailText"]
  mc.emailValue = r["emailValue"]

  return mc
}
