import { TestBed, inject } from '@angular/core/testing'
import { MockBackend, MockConnection } from '@angular/http/testing'
import { Http, BaseRequestOptions, Response, ResponseOptions, RequestMethod } from '@angular/http'

import { MainContentService } from './maincontent.service'
import { MainContent } from './maincontent'

describe('MainContentService', function() {
  let subject: MainContentService
  let backend: MockBackend

  beforeEach(function() {

    TestBed.configureTestingModule({
        providers: [
          MainContentService,
          MockBackend,
          BaseRequestOptions,
          {
            provide: Http,
            useFactory: function(mockBackend, defaultOptions) {
              return new Http(mockBackend, defaultOptions);
              },
            deps: [MockBackend, BaseRequestOptions]
          }
        ]
    })

  })

  beforeEach(inject([MainContentService, MockBackend], function(mainContentService, mockBackend) {
    subject = mainContentService
    backend = mockBackend
  }))

  it('should get data', function(done) {

    backend.connections.subscribe(function(connection: MockConnection) {

      let options = new ResponseOptions({ body: {

          "erevenueUrls": [
            {
              "product": "home",
              "url": "https://DNS.URL"
            },
            {
              "product": "eBilling",
              "url": "https://DNS.URL"
            },
            {
              "product": "eInsurance",
              "url": "https://DNS.URL"
            }
          ]

        }

       })
      connection.mockRespond(new Response(options))
    })

    subject.getContent().subscribe(function(response) {
        expect(response).toEqual(jasmine.any(MainContent))
        expect(response.erevenueUrls.length).toEqual(3)
        expect(response.erevenueUrls[0].product).toEqual('home')
        },
        function(e) {
          console.log(" ERROR:"+e)
        }
    );

    done()
  })

  afterEach(function() {
    TestBed.resetTestingModule()
  })

})
