import { Injectable } from '@angular/core';
import {Http, Response } from '@angular/http';
import { Observable, Subject } from 'rxjs/Rx';

import { ErrorMessage } from './error-message';

@Injectable()
export class ErrorService {
  public errorCode$: Observable<ErrorMessage>;
  public errorSubject: Subject<ErrorMessage>;
  public errorsJson: any;

  constructor(private http:Http) {
    this.errorSubject = new Subject<ErrorMessage>();
    this.errorCode$ = this.errorSubject.asObservable();
  }

  public setErrorCode(code, stackTrace?) {
    this.http.request('../../assets/config/error_messages.json')
          .subscribe(res => this.errorsJson = res.json(),
            e => {console.log("ERROR!!!!");},
            () => {

              let err = new ErrorMessage();
              err.code = code;
              err.stackTrace = stackTrace;
              err.contactApplication = "eBilling"; // TODO get this from ??????
              err.userName = "Abraham Lincoln"; // TODO get this from ?????

              for(var i=0; i< this.errorsJson.errors.length; i++) {
                if(this.errorsJson.errors[i].errorCode === code) {
                  err.messageUser = this.errorsJson.errors[i].errorMessageUser;
                  err.messageTechnical = this.errorsJson.errors[i].errorMessageTechnical;
                }
              }
              for(var i=0; i< this.errorsJson.contacts.length; i++) {
                if(this.errorsJson.contacts[i].application === err.contactApplication) {
                  err.contactName = this.errorsJson.contacts[i].contact.name;
                  err.contactEmail = this.errorsJson.contacts[i].contact.email;
                }
              }
              var d = new Date();
              err.dateTime = (d.getMonth()+1) + "-" + d.getDate() + "-" + d.getFullYear() + " " + d.getHours() + ":" + d.getMinutes();

              this.errorCode$ = Observable.of(err);
              this.errorSubject.next(err);

            });
  }

  public clear() {
    this.errorCode$ = null;//Observable.of('');
    this.errorSubject.next(null);
  }

  mapError() {

  }

}
