import { TestBed, inject } from '@angular/core/testing'

import { HttpModule, Http, BaseRequestOptions, XHRBackend } from '@angular/http';
import { MockBackend } from '@angular/http/testing';

import { LocalConfig } from './local-config'
import { Config } from './config.service'
import { ConfigApiService } from './config-api.service'

describe('ConfigApiService', () => {
    beforeEach(() => {
        LocalConfig.DataProvider = "memory"
        TestBed.configureTestingModule({
            imports: [HttpModule],
            providers: [{
                provide: Http, useFactory: (backend, options) => {
                    return new Http(backend, options);
                },
                deps: [MockBackend, BaseRequestOptions]
            },
                MockBackend,
                BaseRequestOptions,
                ConfigApiService
            ]
        })
    })

    afterEach(function () {
        TestBed.resetTestingModule()
    })

    it('get', inject([ConfigApiService], async (configService: ConfigApiService) => {
        const apiValue: number = 10
        const p = await configService.get("SecondsForExternalRedirect")
        expect(p).toEqual(apiValue)
    }))

    it('update and get', inject([ConfigApiService], async (configService: ConfigApiService) => {
        const value = "value1"
        await configService.update("name1", value)
        expect(await configService.get("name1")).toEqual(value)
    }))
})