import { BrowserModule } from '@angular/platform-browser';
import { NgModule, ErrorHandler } from '@angular/core';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';

import { AppComponent } from './app.component';

import { routing } from './app.routing';
import { HomepageComponent } from './core/homepage/homepage.component';
import { NotFoundComponent } from './core/not-found/not-found.component';
import { ErrorModalComponent } from './core/error-messages/error-modal/error-modal.component';
import { ErrorService } from './core/error-messages/error.service';
import { ClipboardModule } from 'ngx-clipboard';

import { GlobalErrorHandler } from './global.error-handler'
import { ConfigService } from './core/config/config.service'
import { ActiveState } from './core/activestate/activestate.service'
import { LoggerService } from './core/logger/logger.service';
import { LoggingApiService } from './core/logger/logging-api.service';
import { ConfigApiService } from './core/config/config-api.service';
import { SearchApiService } from './core/search/search-api.service';

import { MccfCommonModule } from './mccf-common/mccf-common.module'
import { MccfEbillingModule } from './mccf-ebilling/mccf-ebilling.module'
import { MccfEinsuranceModule } from './mccf-einsurance/mccf-einsurance.module'
import { MccfEpaymentModule } from './mccf-epayment/mccf-epayment.module'
import { MccfEpharmacyModule } from './mccf-epharmacy/mccf-epharmacy.module'
import { MccfNpiModule } from './mccf-npi/mccf-npi.module'
import { MccfTricarechampvaModule } from './mccf-tricarechampva/mccf-tricarechampva.module'
import { MccfEadminModule } from './mccf-eadmin/mccf-eadmin.module'

import { LinkComponent } from './core/link/link.component';
import { SearchComponent } from './core/search/search.component';

@NgModule({
  declarations: [
    AppComponent,
    HomepageComponent,
    NotFoundComponent,
    ErrorModalComponent,
    LinkComponent,
    SearchComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    ReactiveFormsModule,
    ClipboardModule,
    HttpModule,
    routing,
    MccfCommonModule,
    MccfEbillingModule,
    MccfEinsuranceModule,
    MccfEpaymentModule,
    MccfEpharmacyModule,
    MccfNpiModule,
    MccfTricarechampvaModule,
    MccfEadminModule
  ],
  providers: [
    ErrorService,
    ConfigService,
    ConfigApiService,
    LoggerService,
    LoggingApiService,
    SearchApiService,
    ActiveState,
    { provide: ErrorHandler, useClass: GlobalErrorHandler }
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
