// Protractor configuration file, see link for more information
// https://github.com/angular/protractor/blob/master/lib/config.ts

const Jasmine2HtmlReporter = require('protractor-jasmine2-html-reporter');
const { SpecReporter } = require('jasmine-spec-reporter');
const DEFAULT_TIMEOUT = 120000;  //Change this based on the app's response time.  Default 2-minutes to validate a test.

exports.config = {
  allScriptsTimeout: DEFAULT_TIMEOUT,
  specs: [
    './e2e/src/*.e2e.ts'
  ],
  capabilities: {
    browserName: 'chrome',
    chromeOptions: {
      args: [ "--headless", "--disable-gpu", "--window-size=800x600" ]
    }
  },
  seleniumServerJar: './e2e/selenium/selenium-server-standalone-3.4.0.jar',
  chromeDriver: './e2e/selenium/drivers/chromedriver_2.31.exe',
  directConnect: true,
  baseUrl: 'http://localhost:4200/',
  framework: 'jasmine',
  jasmineNodeOpts: {  // ----- Options to be passed to minijasminenode
      // onComplete will be called just before the driver quits.
      onComplete: null,
      // If true, display spec names.
      isVerbose: false,
      // If true, print colors to the terminal.
      showColors: true,
      // If true, include stack traces in failures.
      includeStackTrace: true,
      // Default time to wait in ms before a test fails.
      defaultTimeoutInterval: DEFAULT_TIMEOUT   //Set this really high for data-driven tests and let Protractor/WebDriver fail an inactive test run.
  },
  onPrepare() {
    require('ts-node').register({
      project: 'e2e/tsconfig.e2e.json'
    });
	// Add a reporter and store screenshots to `screnshots`:
      jasmine.getEnv().addReporter(new Jasmine2HtmlReporter({
        savePath: './e2e/reports/',
        screenshotsFolder: 'screenshots',
        takeScreenshots: true,
        takeScreenshotsOnlyOnFailures: false,
        fixedScreenshotName: false,
        fileNamePrefix: '',
        fileName: 'test-report',
        fileNameSuffix: '',
        fileNameSeparator: '_',
        fileNameDateSuffix: false,
        consolidate: true,
        consolidateAll: true,
        cleanDestination: true,
        showPassed: true
      }));
      jasmine.getEnv().addReporter(new SpecReporter({
        spec: {
          displayStacktrace: true
        }
      }));
    }
};
