#! /bin/bash
#
clear

# CONTACT INFO
CONTACT="Dan McAllister: Daniel.McAllister@Halfaker.com or PII"

# NAME OR IP OF REPO FILES

DEVREPOSRC="aws-master.mccf.halfakerlabs.com"
TARGETREPOFILE=mccf.repo

#
# Verify ROOT user is running this
MYID="`/usr/bin/id -u`"
if [ "$MYID" -ne 0 ] ; then echo $0: You must be root to run this 1>&2 ; exit 1 ; fi
#

echo ""
echo "$0 localize the link address of the ${TARGETREPOFILE}"

TARGETREPOSRC=$(hostname)

if [ -z "${TARGETREPOSRC}" ] 
then
    echo "$0 ${TARGETREPOSRC} not found, contact ${CONTACT}"
fi

echo "$0 Synchronizing install to VA EDE environment... "
echo "$0 My local address is ${TARGETREPOSRC}"

src_ip_esc=${DEVREPOSRC//./\\.}
test=""
test=$( grep "${DEVREPOSRC}" ${TARGETREPOFILE} )

if [ -n "${test}" ]
then

    echo "$0 Replace ${DEVREPOSRC} with ${TARGETREPOSRC} in ${TARGETREPOFILE}, and index.html"
    cp ${TARGETREPOFILE} "${TARGETREPOFILE}.bak"
    cp ${TARGETREPOFILE} "index.html.bak"

    sed -i "s/${src_ip_esc}/${TARGETREPOSRC}/g" ${TARGETREPOFILE}
    sed -i "s/${src_ip_esc}/${TARGETREPOSRC}/g" index.html

else
    echo "$0 ${DEVREPOSRC} not found in ${TARGETREPOFILE}"
fi

echo ""
echo "$0 Copy the relevant files to the html location"

PUBDIR="/var/www/html/pub"
REPODIR="${PUBDIR}/repo/yum"
mkdir ${REPODIR} -p

rsync -av --progress . ${REPODIR} --exclude '.git' --exclude 'README.md' --exclude '*.bak' --exclude '*.sh'

if [ -s "${REPODIR}/${TARGETREPOFILE}" ]
then
    echo "$0 Fix directory owner and permissions"
    chown -R root:root "${REPODIR}"
    chmod 0755 "${REPODIR}"
    find ${REPODIR} -type d -exec chmod 0755 '{}' \;
    find ${REPODIR} -type f -exec chmod 0644 '{}' \;
    echo "$0 task completed"
else
    echo "$0 ${REPODIR}/${TARGETREPOFILE} not found, contact ${CONTACT}"
fi

if [ $? -ne 0 ] ; then echo "$0: Please report any errors to ${CONTACT}" ; fi

