# README #
# MCCF YUM REPOSITORIES #
### What is this repository for? ###

* This is MCCF YUM repository, which is used for collecting packages for transfer to VA

### How do I get set up? ###

#### Summary of set up ####

To add the repository to your system and enable it, using one of the following options:

1. Use yum configuration manager

        [  ~]$ sudo yum-config-manager --add-repo http://aws-master.mccf.halfakerlabs.com/pub/repo/yum/mccf.repo

       output:

            Loaded plugins: fastestmirror
            adding repo from: http://aws-master.mccf.halfakerlabs.com/pub/repo/yum/mccf.repo
            grabbing file http://aws-master.mccf.halfakerlabs.com/pub/repo/yum/mccf.repo to /etc/yum.repos.d/mccf.repo
            repo saved to /etc/yum.repos.d/mccf.repo

2. Use wget

        [  ~]$ sudo wget -O /etc/yum.repos.d/mccf.repo http://aws-master.mccf.halfakerlabs.com/pub/repo/yum/mccf.repo
       
       output: 

           Connecting to aws-master.mccf.halfakerlabs.com:80... connected.
           HTTP request sent, awaiting response... 200 OK
           Length: 135
           Saving to: ‘/etc/yum.repos.d/mccf.repo’

3. copy to `yum.repos.d` after downloading from git repo
       
        [  ~]$ sudo cp <sourcepath>/mccf.repo /etc/yum.repos.d/mccf.repo

       To list all enabled repos:

           yum repolist
           yum repolist enabled

       To list disabled repos:

           yum repolist disabled

       To determine the available repos for mccf:
      
          cat /etc/yum.repos.d/mccf.repo | grep "\[.*\]"

4. Enable the repo

        [  ~]$ sudo yum-config-manager --enable mccf


Download and import the GPG Key

1. Get the key from the AWS repo

        [  ~]$ sudo wget http://aws-master.mccf.halfakerlabs.com/pub/repo/yum/RPM-GPG-KEY-MCCF

2. Alternatively, get the key from this repository

3. Check the fingerprint of the GPG key with the gpg command to make sure it matches the published key

        [  ~]$ sudo gpg --quiet --with-fingerprint ./RPM-GPG-KEY-MCCF

4. import the GPG key using the rpm command

        [  ~]$ sudo rpm import ./RPM-GPG-KEY-MCCF


#### Available repos to date ####

| REPO | DESCRIPTION | STATUS
|---|:---|---
|MCCF | This is the repo that has the files that DO go into the EDE | in-progress

To install the packages in the repo

        [ ~]$ sudo yum groupinstall "MCCF"

#### Configuration ####

To configure repo for local use, the `mccf.repo` file will need to be edited to change the baseurl

TODO: list steps for localizing here

### Contribution guidelines ###

To have something added to the repository, please contact 

* Matt Jenks - System Architect 
* Dan McAllister -  Linux System Administrator
* Lee Benhart - Configuration Manager
