import jenkins.model.*
import hudson.model.*
import hudson.security.*
import jenkins.security.*
import groovy.xml.XmlUtil
import groovy.xml.StreamingMarkupBuilder
import groovy.util.slurpersupport.GPathResult


def userId = args[0]
def jenkinsHome = Jenkins.instance.getRootDir().absolutePath
def cfgFile = new File(jenkinsHome, 'config.xml')
def cfgBackup = new File(jenkinsHome, 'config.xml.bak')
def existingUser = User.get(userId)

if(cfgBackup.exists()){
  boolean fileSuccessfullyDeleted =  cfgBackup.delete()
  println ("remove previous config backup, ${cfgBackup}: ${fileSuccessfullyDeleted}")
}

println ("backup existing config file")

cfgBackup << cfgFile.text

println("--> preparing to remove user: " + userId)

if (existingUser != null) {
    println("--> preparing to delete user: " + existingUser)
    existingUser.delete()
}

println ("get global perms for `${userId}` from ${cfgFile}")

def xmlSlrp = new XmlSlurper()
def globalPerms = xml2perms(userId, xmlSlrp.parse(cfgFile).authorizationStrategy).join('\n\t')

println ("\nGlobal Perms for ${userId}:\n\t" + globalPerms)

println ("\nremove globalPerms for ${userId} from ${cfgFile}")

// Parses the text in the file using an XmlSlurper
// Finds all authorizationStrategy permissions  containing 'userId'
// Removes each one found.
// Calls a method that serializes the XML as a string.

processFileInplace(cfgFile) { text ->
    hudson = new XmlSlurper().parseText(text)
    hudson.authorizationStrategy.permission.findAll{it.text().contains(userId)}.replaceNode{}
    serializeXml(hudson)
}

try{
  println ("reload jenkins config file from disk")
  Jenkins.instance.doReload()
}
catch(Exception e){
  println e
}

def xml2perms(userName, xmlData){
  xmlData.permission.collect {
    it.text().split(':')
  }.findAll {
    it[1] == userName
  }.collect {
    it[0]
  }
}

def processFileInplace(file, Closure processText) {
    def text = file.text
    file.write(processText(text))
}

def String serializeXml(GPathResult xml){
    XmlUtil.serialize(new StreamingMarkupBuilder().bind {
        mkp.yield xml
      } )
}