import hudson.model.User
import hudson.tasks.Mailer
import jenkins.model.Jenkins

def jenkinsHome = Jenkins.instance.getRootDir().absolutePath
def cfgFile = new File(jenkinsHome, 'config.xml')

//println("get realm")
def realm = Jenkins.getInstance().getSecurityRealm()
println("Display Name, User ID, Email Address, Global Permission")
def users = realm.getAllUsers()
if (users) {
  for (User u : users) {
    def id=u.getId()
    def displayName = u.getDisplayName()
    def mailAddress = u.getProperty(Mailer.UserProperty.class).getAddress()
    def xmlSlrp = new XmlSlurper()
    def globalPerms = xml2perms(id, xmlSlrp.parse(cfgFile).authorizationStrategy).join(', ')    
    println(displayName + "," + id + "," + mailAddress + "," + globalPerms)
  }
}

def xml2perms(userName, xmlData){
  xmlData.permission.collect {
    it.text().split(':')
  }.findAll {
    it[1] == userName
  }.collect {
    it[0]
  }
}