#! /bin/bash
#
#set -x
clear

args=("$@")

scriptname=${0}
scriptBase="$( cd "$( dirname "$scriptname" )";  pwd)"
VAULTPASS_PATH="~/.vault_pass"
echo "${VAULTPASS_PATH}"

function usage() {
  echo "usage: $scriptname ENV HOSTS"
  echo "      where ENV = AWS_DEV | EDE_ALL | EDE_CI | EDE_CIT | EDE_DEV | EDE_SQA | EDE_UAT | local"
  echo "      where HOSTS = all | ci-server | webserver | dbserver "
  return 1
}

#currently cannot verify syntax of roles which do not exist.
function verifySyntax() {
  if [ $# -eq 1 ]
  then
    if [[ "${ENV}" == "local" ]]
    then
        echo "ansible-playbook ${1} --syntax-check --list-tasks"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}" --syntax-check --list-tasks
    else
        echo "ansible-playbook ${1} --syntax-check --list-tasks --vault-password-file ${VAULTPASS_PATH}"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}" --syntax-check --list-tasks --vault-password-file ${VAULTPASS_PATH}
    fi
  else 
    echo "Please supply playbook"
    exit 1
  fi
}

function runPlaybook() {
  if [ $# -eq 1 ]
  then
    echo "Running ${ENV} install of Jenkins"
    if [[ "${ENV}" == "local" ]]
    then
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars var_hosts=${HOSTS}"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}"
    else
        echo "ansible-playbook ${1} -i ../environments/${ENV} --extra-vars var_hosts=${HOSTS} --vault-password-file ${VAULTPASS_PATH}"
        ansible-playbook ${1} -i "../environments/${ENV}" --extra-vars "var_hosts=${HOSTS}" --vault-password-file ${VAULTPASS_PATH}
    fi
  else 
    echo "Please supply playbook"
    exit 1
  fi
}

if [ $# -lt 2 ]
  then
    ARGC=$#  # Number of args, not counting $0
    echo "Number of args: $ARGC"
    usage
else
  ENV=${args[0]}
  HOSTS=${args[1]}
  playbooks=("installCIrequirements.yml" "configure-ci-server.yml")
  
  for item in "${playbooks[@]}"
  do
    playBook=${item}
    echo
    echo "verify syntax for playbook ${playBook} for ${ENV} ${HOSTS}"
    verifySyntax ${playBook}
    statuscheck=$?
    if [ $statuscheck -eq 0 ]
    then
      echo "status = ${statuscheck}"
      runPlaybook ${playBook}
      echo
    else
      echo "there was a problem with the playbook: ${playBook}"
      exit 1
    fi
  done
  if [[ "${ENV}" == "local" ]]
  then
    echo "Admin User is is 'jenkins_admin'"
    echo "Password is 'Password123!'"
  fi
      # CONTACT INFO
  CONTACT="Dan McAllister: Daniel.McAllister@Halfaker.com or PII"

  echo ""
fi
