// Karma configuration file, see link for more information
// https://karma-runner.github.io/0.13/config/configuration-file.html

module.exports = function (config) {
  config.set({
    basePath: '',
    frameworks: ['jasmine', '@angular/cli'],
    plugins: [
      require('karma-jasmine'),
      require('karma-chrome-launcher'),
      require('karma-phantomjs-launcher'),
      require('karma-verbose-reporter'),
      require('karma-jasmine-html-reporter'),
      require('karma-html-reporter'),
      require('karma-coverage-istanbul-reporter'),
      require('@angular/cli/plugins/karma')
    ],
    client: {
      clearContext: false // leave Jasmine Spec Runner output visible in browser
    },
    coverageIstanbulReporter: {
      reports: ['html', 'lcovonly'],
      fixWebpackSourcePaths: true
    },
    angularCli: {
      environment: 'dev'
    },
    customLaunchers: {
      CustomHeadlessChrome: {
        base: 'Chrome',
        flags: ["--headless", "--disable-gpu", '--remote-debugging-port=9222',]
      }
    },
    reporters: ['verbose', 'progress', 'kjhtml', 'html'],
    port: 9876,
    htmlReporter: {
      "outputDir": ".", // where to put the reports
      "templatePath": null, // set if you moved jasmine_template.html
      "focusOnFailures": true, // reports show failures on start
      "namedFiles": true, // name files instead of creating sub-directories
      "pageTitle": "unit_test_results", // page title for reports; browser info by default
      "urlFriendlyName": false, // simply replaces spaces with _ for files/dirs
      "reportName": "unit_test_report_summary" // report summary filename; browser info by default
    },
    colors: true,
    logLevel: config.LOG_INFO,
    autoWatch: true,
    browsers: ['PhantomJS'], // also available: CustomHeadlessChrome
    singleRun: true
  });
};
