import { GlobalPgObjs } from './glbl.po';
import { GlobalTestData } from './glbl.tdata';
/**  
 * ResE2EGlobals - a global class for accessing page objects and test data.  
 */ 
export class ResE2EGlobals {
/**
 * getPageObjects() - an accessor method used to instantiate a global storage place, for all of the required representations, for all of the web pages in the application.
 * @returns new GlobalPgObjs() - makes an instantiated object that can be used to access a specific representation of a web page for testing the application.
 */
	getPageObjects() {
		return new GlobalPgObjs();
    }
/**
 * getTestData() - an accessor method used to instantiate a global storage for test data to be used when testing the application.
 * @returns new GlobalTestData() - returns an instantiated object for accessing specific test data.
 */
    getTestData() {
		return new GlobalTestData();
    }
 }