export class BuiltIn {
	constructor(private logger = null) {}
/**
,-[Should Be Equal	first, second, msg=None, values=True, ignore_case=False	
Fails if the given objects are unequal.
Optional msg and values arguments specify how to construct the error message if this keyword fails:
If msg is not given, the error message is <first> != <second>.
If msg is given and values gets a true value (default), the error message is <msg>: <first> != <second>.
If msg is given and values gets a false value, the error message is simply <msg>. See Boolean arguments for more details about using false values.
If ignore_case is given a true value (see Boolean arguments) and arguments are strings, it indicates that comparison should be case-insensitive. New option in Robot Framework 3.0.1.
If both arguments are multiline strings, the comparison is done using multiline string comparisons.
*/
	shouldBeEqual (first, second) {
		this.getLoggerInstance().log('info', 'BuiltIn.shouldBeEqual ' + first + ', ' + second, 'keyword');
		return (first === second);
	}

//Should be called automatically by selenium.keys
	setLoggerInstance(logger) {
		this.logger = logger;
	}

	getLoggerInstance() {
		return this.logger;
	}
}	