import * as ptor from 'protractor';
import * as fs from 'fs';
import * as json2html from 'node-json2html';
import * as aXeBuilder from 'axe-webdriverjs';

export class AxeLibrary {
	constructor(private url, private pgName) {
		ptor.browser.get(this.url).then(function () {
			aXeBuilder(ptor.browser.driver)
			.analyze(function (results) {
				var data = JSON.stringify(results) 
				data = data.replace(/\</g,"&lt;")   //for <
				data = data.replace(/\>/g,"&gt;")   //for >
				fs.writeFileSync('e2e/logs/AxeResults.json', data);
                console.log("Axe test complete, exported to AxeResults.json"); 
  //List item transform
  //@See - https://stackoverflow.com/questions/38145723/json2html-create-inline-function-for-json-data-in-array-w-multiple-elements
				let passesIdx = 0;

//define transform for pass
				let transform = {"tag":"div","children":function(){
			        return(json2html.transform(this.passes, passesTransform));
				}};

				let passesTransform = {"tag":"div","html":'</tbody></table></details><details><summary style="font-size: 14pt; font-weight: bold; text-transform: uppercase">${help}&nbsp;&nbsp;<span style="color: #27ae60">&#10004;</span></summary><table _ngcontent-c2=""class="usa-table"><thead _ngcontent-c2=""><tr _ngcontent-c2=""><th _ngcontent-c2=""><ul style="list-style: none; font-size: 14pt;">${description}<li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>URL:</strong>&nbsp;&nbsp;<a href="${helpUrl}">${helpUrl}</a></li><li style="font-weight: normal;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>ID:&nbsp;&nbsp;</strong> ${id}</li><li style="font-weight: normal;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Tags:&nbsp;&nbsp;</strong><em>${tags}</li></th></tr></thead>',"children":function(){
					return(json2html.transform(this.nodes, passingNodesTransform));
				}};

				let passingNodesTransform = {"tag":"div","html":'<tbody _ngcontent-c2=""><tr _ngcontent-c2=""><td _ngcontent-c2=""><ul style="list-style: none; font-size: 14pt;"><strong>HTML:</strong>&nbsp;&nbsp;${html}<li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>ID:</strong>&nbsp;&nbsp;${none.0.id}</li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Data:</strong>&nbsp;&nbsp;${none.0.data}</li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Result:</strong>&nbsp;&nbsp;${none.0.message}&nbsp;&nbsp;<span style="color: #27ae60">&#10003;</span></li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Impact:</strong>&nbsp;&nbsp;${none.0.impact}</li></ul></td></tr>'}

				let html = '<h3 _ngcontent-c1="" class="report-topics-title">' + this.pgName + ' Page</h3><br/><br/><div><span class=usa-label-pass>Passes:</span></div><br>';
        		html = (html + json2html.transform(data, transform) + '</tbody></table></details>');

//redefine transform for fails
				transform = {"tag":"div","children":function(){
				        return(json2html.transform(this.violations, violationsTransform));
				}};

			    let violationsTransform = {"tag":"div","html":'</tbody></table></details><details><summary style="font-size: 14pt; font-weight: bold; text-transform: uppercase">${help}&nbsp;&nbsp;<span style="color: #c0392b">&#x2718;</span></summary><table _ngcontent-c2=""class="usa-table"><thead _ngcontent-c2=""><tr _ngcontent-c2=""><th _ngcontent-c2=""><ul style="list-style: none; font-size: 14pt;">${description}<li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>URL:</strong>&nbsp;&nbsp;<a href="${helpUrl}">${helpUrl}</a></li><li style="font-weight: normal;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>ID:&nbsp;&nbsp;</strong> ${id}</li><li style="font-weight: normal;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Tags:&nbsp;&nbsp;</strong><em>${tags}</li></th></tr></thead>',"children":function(){
					return(json2html.transform(this.nodes, failingNodesTransform));
				}};		

				let failingNodesTransform = {"tag":"div","html":'<tbody _ngcontent-c2=""><tr _ngcontent-c2=""><td _ngcontent-c2=""><ul style="list-style: none; font-size: 14pt;"><strong>HTML:</strong>&nbsp;&nbsp;${html}<li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>ID:</strong>&nbsp;&nbsp;${none.0.id}</li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Data:</strong>&nbsp;&nbsp;${none.0.data}</li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Result:</strong>&nbsp;&nbsp;${none.0.message}&nbsp;&nbsp;<span style="color: #c0392b">&#x2718;</span></li><li style="font-weight: normal; margin-top: 10px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<strong>Impact:</strong>&nbsp;&nbsp;${none.0.impact}</li></ul></td></tr>'}	

				html = (html + '<br/><div><span class=usa-label-fail>Violations:</span></div><br>');
        		html = (html + json2html.transform(data, transform) + '</tbody></table></details>');

//HTML formatter
        		let htmlTopper = fs.readFileSync("e2e/logs/axe-report-assets/tmp/AxeResultsTopper.html", "utf8");
				html = (htmlTopper + html);
				let htmlBottom = fs.readFileSync("e2e/logs/axe-report-assets/tmp/AxeResultsBottom.html", "utf8");
				html = (html + htmlBottom)
// END				
				fs.writeFileSync('e2e/logs/AxeResults.html', (html));
				console.log("Transform complete, exported to AxeResults.html"); 
			});
		});
	}
}