<%@ include file="inc_header.jsp"%>

<script type="text/javascript">
	$(
			function() {
				var theTable = $('#userTable').DataTable({
					"dom" : '<"top">rt<"bottom"><"clear">',
					autowidth : true,
					searching : false,
					select : 'single',
					"language" : {
						"emptyTable" : '<span tabIndex="0">No users were found.</span>'
					}
				})

				$("#selectUserButton")
						.click(
								function() {
									var theUser = $('#userTable').data(
											'selectedUsername')
									if (theUser)
										document.location.href = 'ShowManageUsersEdit.html?userName='
												+ theUser
												+ "&fromPage=userSearch"
								})

				$('#userTable tbody').on(
						'click',
						'tr',
						function() {
							var theRow = $(this)
							var isSelected = theRow.hasClass('selected')
							var theTable = $('#userTable')
							theTable.removeData('selectedUsername')
							if (isSelected)
								theTable.data('selectedUsername', theRow
										.attr('username'))
							$('#selectUserButton').toggle(isSelected)
						})
			})
			
	function forceFocusOnTableHeader() {
		$(this).parent().focus()	
	}
</script>

<table id="userTable" border="1" summary="List of Users">
	<thead>
		<tr>
			<th tabIndex="0" aria-label="Press Enter to Sort User ID">User ID</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Name">Name</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Title">Title</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Department">Department</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Office">Office</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Phone Number">Phone Number</th>
			<th tabIndex="0" aria-label="Press Enter to Sort Visn">VISN</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${users}" var="user">
			<tr username="<c:out value="${user.username}" />">
				<td tabIndex="0"><c:out value="${user.username}" /></td>
				<td tabIndex="0"><c:out value="${user.fullName}" /></td>
				<td tabIndex="0"><c:out value="${user.title}" /></td>
				<td tabIndex="0"><c:out value="${user.department}" /></td>
				<td tabIndex="0"><c:out value="${user.office}" /></td>
				<td tabIndex="0"><c:out value="${user.telephoneNumber}" /></td>
				<td tabIndex="0"><c:out value="${user.visn.id}" /></td>
			</tr>
		</c:forEach>
	</tbody>
</table>

<div style="margin-top: 10px">
	<input type="button" class="button" title="Select" id="selectUserButton"
		value="Select" style="display: none" /> <input type="button"
		class="button" title="Cancel" id="cancelButton" value="Cancel"
		onclick="document.location.href='manageUsersSearch.html'" />
</div>