<%@ include file="inc_header.jsp"%>

<%--Allow these to be set either in the model or in the tiles config - CPB --%>
<c:if test="${empty pageTitle}">
	<tiles:importAttribute name="pageTitle" scope="page" ignore="true" />
</c:if>

<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
<meta http-equiv="X-UA-Compatible" content="IE=edge" />

<%@ include file="inc_common.jsp" %>

<script>
$( document ).ready(function() {

   	$('#skip h4').on('click', function(){
		$('.moduleTitle h4').focus();		
	});
	
	 $('#skip h4').on('keyup', function(e){
		 if(e.which == 13)
		$('.moduleTitle h4').focus();		
	});

});
</script>

<title><c:out value="${pageTitle}" /></title>

</head>
<body>
	<div id="skip">
		<h4 aria-label="Skip to Page Content" title="Skip to Page Content" tabindex="0">Skip to Page Content</h4>
	</div>
	<div class="container">
		<header>
			<div class="pageBanner">
				<img src="images/ihta_banner.jpg"
					alt="Department of Veterans Affairs Integrated Home Telehealth Application With V A Seal" tabindex="0" />
			</div>
			<c:if test="${showWelcomeBar}">
			<div class="headerInfo">

				<h4 class="welcomeMessage" tabindex="0">
					Welcome: 
					<c:out value="${userDisplayName}" />
				</h4>

				<h4 class="piiMessage" tabindex="0">Do NOT enter any Personally
					Identifiable Information (PII) into this system!</h4>

				<a href="${logoutManualUrl}"
					onClick="return(logoutConfirm()); return false;"
					class="headerLogOutLink" tabindex="0">Log Out</a> 	

	
				<a href="/ccht/help.html" target="_blank" tabindex="1">
					<img src="images/helpicon.png" alt="Integrated Home Tele Health Online Help Will Open In A New New Window" class="headerHelpLink" tabindex="0" />
				</a>
				<img src="/ccht/images/spacer.gif" alt="" height="0" width="20" />
				<c:if test="${notifyPendingRegistrations}">
					<a href="/ccht/manageRegistrations.html" tabindex="1">
						<img src="/ccht/images/mail_icon.png" alt="Pending Registrations Notification" class="headerRegistrationReminderIcon" tabindex="0"	>
					</a>
				</c:if>	
			</div>
			</c:if>	

			<%@ include file="menu.jsp"%>
		</header>

		<div class="moduleContainer">
			<c:if test="${not empty pageTitle}">

				<div class="moduleTitle">
					<h4 tabindex="0">
						<c:out value="${pageTitle}" />
					</h4>
				</div>
			</c:if>

			<%@ include file="inc_informationMessage.jsp" %>
		</div>

		<main role="main" style="margin-top: 10px;">
		<div style="min-height: 500px">
			<tiles:insertAttribute name="body" />
		</div>
		</main>
		<%@ include file="inc_countdownTimer.jsp" %>
		<footer>
			<jsp:include page="footer.jsp" />
		</footer>
	</div>
</body>
</html>