<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
        $(reportTitle).focus();
        
		var nationalTotalsResultsTable = $('#responseRateVisnResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			columnDefs: [
				{ targets: 0, "width": "200px"},
				{ targets: '_all', "width": "150px" }
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
	})
</script>

<div id="responseRateVisnResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="responseRateVisnResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th tabIndex="0" aria-label="VISN">VISN</th>
			<th tabIndex="0" aria-label="Responders">Responders</th>
			<th tabIndex="0" aria-label="Partial Responders">Partial Responders</th>
			<th tabIndex="0" aria-label="Non-Responders">Non-Responders</th>
			<th tabIndex="0" aria-label="Unknown">Unknown</th>
			<th tabIndex="0" aria-label="TOTAL">TOTAL</th>
			<th tabIndex="0" aria-label="Non-response for more than 30 days">Non-response for more than 30 days</th>
			<th tabIndex="0" aria-label="Greatest days of non-response">Greatest days of non-response</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${responseRateRows}" var="row">
			<tr>
				<c:choose>
					<%-- There's not really a better way to do this, but the last two rows
					are special cases so you need to match them to this first column value. --%>
					<c:when test="${row.vendorName == 'TOTALS BY RESPONSE RATE'}">
						<td tabIndex="0">${row.vendorName}</td>
						<td tabIndex="0"><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0">TOTAL PTS REPORTED</td>
						<td></td>
						<td></td>
					</c:when>
					<c:when test="${row.vendorName == 'PERCENT OF TOTAL'}">
						<td tabIndex="0">${row.vendorName}</td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnOne}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnTwo}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnThree}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.columnFour}" type="percent" minFractionDigits="2"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.total}" type="number" groupingUsed="true"/></td>
						<td></td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td tabIndex="0">
						<!-- Give the appearance of a link for drilling down into visn and facility. -->
						<form:form method="post" action="responseRateReports.html" commandName="form" class="inline">
							<input type="hidden" name="rrDrillDownVisn" value="true"/>
							<form:hidden path="reportID" value=2/>
							<form:hidden path="categoriesOfCare" value="${categoriesOfCare}"/>
							<form:hidden path="modalityCode" value="${modalityCode}"/>
							<form:hidden path="reportEndDate" value="${reportEndDate}"/>
							<form:hidden path="visnId" value="${row.visnId}"/>
							<form:hidden path="vendorId" value="${vendorId}"/>
                            <form:hidden path="buttonSelection" value="${buttonSelection}"/>
                            <form:hidden path="originalReportVisnId" value="${originalReportVisnId}"/>  
                            <form:hidden path="showVendorSubtotals" value="${showVendorSubtotals}"/>
							<%-- This is actually the VISN name --%>
							<button type="submit" value="Submit" class="link-button" tabIndex="0">${row.vendorName}</button>
						</form:form> </td>
						<td tabIndex="0"><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.total}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.thirtyDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
						<td tabIndex="0"><fmt:formatNumber value="${row.greatestDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<form action="responseRateReports.html">
    <input id="reportsMenuButton" tabindex="0" class="submitAnchor ui-button" type="submit" value="Reports Menu" />
</form>

<%@ include file="vendorReportStatus.jsp"%>
<%@ include file="responseRateInfo.jsp" %>