<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script type="text/javascript">

	$(function() {
		var resultsTable = $('#vendorSubResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "20%", "targets": 0},
				{"width": "25%", "targets": 1},
			],
            "language" : {
                // Messages used in the case that selections render no data.
                "emptyTable" : '<span tabIndex="0">No data found.</span>',
                "infoEmpty" : '<span tabIndex="0">No data found.</span>'
            }
		});
		
	})
</script>

<div id="vendorSubResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="vendorSubResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th tabindex="0">Vendor</th> 
			<th tabindex="0"># Days Since Last Survey Submission</th>
			<th tabindex="0">Ver 1 Number of Surveys</th>
			<th tabindex="0">Ver 2 Number of Surveys</th>
			<th tabindex="0">Total Number of Surveys</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${vendorSubReport}" var="report">
			<tr>
				<td tabindex="0">${report.vendorName}</td>
				<td tabindex="0">${report.dateLastSurveyWithDays}</td>
				<td tabindex="0"><fmt:formatNumber value="${report.surveyVersionOneTotal}" type="number" groupingUsed="true"/></td>
				<td tabindex="0"><fmt:formatNumber value="${report.surveyVersionTwoTotal}" type="number" groupingUsed="true"/></td>
				<td tabindex="0"><fmt:formatNumber value="${report.totalNumberOfSurveys}" type="number" groupingUsed="true"/></td>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>

<%@ include file="pssQuestions.jsp"%>
