<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script src="js/pssReports.js"></script>

<script type="text/javascript">

</script>

<script src="js/rgraph/RGraph.common.core.js"></script>
<script src="js/rgraph/RGraph.common.key.js"></script>
<script src="js/rgraph/RGraph.drawing.yaxis.js"></script>
<script src="js/rgraph/RGraph.drawing.xaxis.js"></script>
<script src="js/rgraph/RGraph.bar.js"></script>
<script src="js/rgraph/RGraph.line.js"></script>

<script type="text/javascript">

$(function() {
            $(reportPageTitle).focus();
            
			isBarGraph();
			isLineGraph();
			
			var resultsTable = $('#surveyTrendsResultsReportTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "300px", "targets": 0},
				{"width": "100px", "targets": "_all"},
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
	});
	
	function isBarGraph() {	
	<c:if test="${generateBarGraph}">
			$(function(){
				<c:if test="${hasData}">
					generateBarGraph();
				</c:if>
			});
		</c:if>
	}
	function isLineGraph() {
		<c:if test="${generateLineGraph}">
			$(function(){
				<c:if test="${hasData}">
					generateLineGraph();
				</c:if>
			});
		</c:if>
	}
	
	//Method used to get a number 20,000 over highest data point to be used as the top of the y Axis scale
	function getMaxOfArray(numArray) {
		var yMax = Math.max.apply(null, numArray);
		yMax = yMax/10000;
		yMax = Math.round(yMax);
		yMax = yMax*10000;
		yMax = yMax+20000;
  		return  yMax;
	}
	
	
	function generateBarGraph() {
		var dataArray = new Array();
		var surveyXAxis = new Array();
		<c:if test="${fn:length(surveyReportTotals) > 0}">
			var count = 0;
			<c:forEach var="x" begin="0" end="${fn:length(surveyReportTotals)-1}">
				dataArray.push("${surveyReportTotals[x]}");
				if(count % 2 == 0){
					surveyXAxis.push("${xAxis[x]}");
					
				}else{
					surveyXAxis.push("\r\n${xAxis[x]}");
				}
				if("${isAllVISNS}" == "true"){
					count++;
				}
			</c:forEach>
		</c:if>
		// Arbitrarily split the title, as it can grow beyond the div. 
		var splitTitle = "${graphTitle}";
		var maxChars = 80;
		var count = maxChars;
		for(i = 0; i < splitTitle.length; i++) {
			if(count < 1 && splitTitle.charAt(i) == ' ') {
				splitTitle = splitTitle.substr(0,i) + '\n' + splitTitle.substr(i+1, splitTitle.length);
				count = maxChars;
			}
			count--;
		}
		
		var yMax = getMaxOfArray(dataArray);
		var bar = new RGraph.Bar({
	        id: 'chart-container',
	        data: dataArray,
	        options: {
	            titleY: 10,
	            colors: ['#00B9F2'],
	            title: splitTitle,
	            gutterBottom: 50,
	            gutterTop: 50,
	            labelsAbove: true,
	            labelsAboveOffset: 5,
	            ymax: yMax
	        }
	    }).draw();	

	    new RGraph.Drawing.XAxis({
			id: 'chart-container',
			y: bar.canvas.height - bar.gutterBottom,
			options: {
				gutterLeft: bar.gutterLeft,
				labels: surveyXAxis,
				textAngle: 45,
				textSize: 14
			}
		}).draw();
		
	}
	
	function generateLineGraph() {
		var dataArray = new Array();
		var surveyXAxis = new Array();
		<c:if test="${fn:length(surveyReportTotals) > 0}">
			var count = 0;
			<c:forEach var="x" begin="0" end="${fn:length(surveyReportTotals)-1}">
				dataArray.push("${surveyReportTotals[x]}");
				if(count % 2 == 0){
					surveyXAxis.push("${xAxis[x]}");
					
				}else{
					surveyXAxis.push("\r\n${xAxis[x]}");
				}
				if("${isAllVISNS}" == "true"){
					count++;
				}
			</c:forEach>
		</c:if>
		// Arbitrarily split the title, as it can grow beyond the div. 
		var splitTitle = "${graphTitle}";
		var maxChars = 80;
		var count = maxChars;
		for(i = 0; i < splitTitle.length; i++) {
			if(count < 1 && splitTitle.charAt(i) == ' ') {
				splitTitle = splitTitle.substr(0,i) + '\n' + splitTitle.substr(i+1, splitTitle.length);
				count = maxChars;
			}
			count--;
		}
		var yMax = getMaxOfArray(dataArray);
		var data =[dataArray];
    	var line = new RGraph.Line({
	        id: 'chart-container',
	        data: data,
	        options: {
	        	titleY: 10,
	            colors: ['#00B9F2'],
	            title: splitTitle,
	            gutterBottom: 50,
	            gutterTop: 50,
	            numxticks: "${fn:length(surveyReportTotals)}",
	            labelsAbove: true,
	            labelsAboveOffset: 5,
	            ymax: yMax
	        }
   		}).draw();
   		
   		new RGraph.Drawing.XAxis({
			id: 'chart-container',
			y: line.canvas.height - line.gutterBottom,
			options: {
				labels: surveyXAxis,
				textAngle: 45,
				textSize: 14
			}
		}).draw();
	}
</script>

<div id="PssTrendsResultsReportContainer" style="margin: auto">
	<h3 id="reportPageTitle" tabIndex="0" aria-live="assertive">Home Telehealth Survey Trend Charts </h3>
	<!-- If there is no results returned display message to user No data found -->
	<c:if test="${hasData ne true}">
		<div tabIndex="0"> No Data Found for ${dateRange}</div>
	</c:if>	
	<table role="presentation">
		<tbody>
			<tr>
				<td>
					<!-- The Yaxis survey count labels were covering the yaxis title-->
					<!-- This creates a title that is next to the graph only when there is data to form a graph-->
					<c:if test="${hasData && (generateLineGraph || generateBarGraph)}">
						<div style="transform: rotate(-90deg); font-size: 20px; width: 280px;" tabIndex="0">Number of Survey Responses</div>
					</c:if>
				</td>
				<td>
					<c:if test="${generateLineGraph || generateBarGraph}">
						<div id="chartDialog" tabIndex="0" style="display: inline-block; margin: 0 auto" >
			  				<canvas  width="900px" height="400px" id="chart-container" ></canvas>
						</div>
					</c:if>
					<c:if test="${generateTable && hasData}">
						<div>
							<h3 tabIndex="0" style="display: inline-block; margin: 0 auto" >${graphTitle}</h3>
							<table id="surveyTrendsResultsReportTable" tabIndex="0" class="compact stripe dt-head-left dt-body-left hover cell-border">
								<thead>
									<tr>
										<th>${tableHeader}</th>
										<c:forEach var="x" begin="0" end="${fn:length(xAxis)-1}">
											<th>${xAxis[x]}</th> 
										</c:forEach>
									</tr>
								</thead>
								<tbody>
									<tr>
										<td tabIndex="0"> Number of Survey Responses</td>
										<c:forEach var="x" begin="0" end="${fn:length(surveyReportTotals)-1}">
											<td tabIndex="0">${surveyReportTotals[x]}</td>
										</c:forEach>
									</tr>									
								</tbody>
							</table>
						</div> 
					</c:if>
				</td>
			</tr>
			<!-- The Xaxis labels were covering the Xaxis title-->
			<!-- This creates a title that is beneath the graph only when there is data to form a graph-->
			<!-- This all checks whether the report is being for all VISNS which displays the data by VISN instead of by month-->
			<tr>
			<!--<td><div>                                         </div></td>  -->
				<td colspan="2" style="margin: auto; text-align: center" >
					<c:if test="${hasData && (generateLineGraph || generateBarGraph)}">
						<div style="display: inline-block; margin: auto; font-size: 20px" tabIndex="0"> ${xAxisTitle}</div>
					</c:if>
				</td>
			</tr>
		</tbody>
	</table>
</div>
<br>

<%@ include file="reportsMenuButton.jsp"%>

<%@ include file="pssQuestions.jsp"%>