<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script src="js/pssReports.js"></script>

<script type="text/javascript">
</script>

<div id="waitingDialog" style="display: none;">
    <strong tabindex="0">Generating Report. Please wait...</strong>
</div>

<form:form method="post" action="pssStatisticsReport.html" modelAttribute="pssReportForm">
<form:errors path="*" cssClass="error" element="div" tabIndex="0"/>
    <table id="pssReportsTable" role="application">
        <tr><td colSpan="2"><label tabindex="0">The Patient Level of Satisfaction and the Patient Satisfaction Index
        for a set of Patient Satisfaction surveys will be displayed. 
        To define the set of surveys and the context for the surveys 
        please enter a date range and select National, VISN or facility.</label></td></tr>
        <tr><td colSpan="2" id="graphInstructions"><label tabindex="0">NOTE: In order to see a graph of the Question's 
        Satisfaction percentages, run the report for six time intervals or less, then when the report output 
        is generated, click on one of the questions.</label></td></tr>
        <tr>
		  <td colSpan="1" width="109px" align="right" style="padding-right:39px">
		    <form:radiobutton path="dateTypeSelection" value="1" alt="Month date selection"  tabIndex="0"/>
		    <label tabIndex="0" text-align="right"><b>Month:</b></label>
		  </td>
	      <td colSpan="1" width="75" style="padding-left: 16px">
	        <label tabIndex="0"><b>From:    </b></label>
	      </td>
	      <td colSpan="1" class="fromSpan2">
	        <form:select path="shortFormatReportFromDate" id="fromDateInput" disabled="false" alt="Month From Date">
	          <form:option value="${fromDate}" />
	          <form:options items="${dateByMonths}" />
	        </form:select>
	      </td>
	      <td colSpan="1" width="59" style="padding-left: 16px">
		    <label tabIndex="0"><b>To:    </b></label>
		  </td>
		  <td colSpan="1" class="fromSpan2">
		    <form:select path="shortFormatReportToDate" id="toDateInput" disabled="false" alt="Month To Date">
		      <form:option value="${toDate}"/>
		      <form:options items="${dateByMonths}" />
		    </form:select>
		  </td>
		</tr>
        
        <%@ include file="pssReportDateMenu.jsp" %>
        <tr>
            <td colSpan="2" class="centerSpan" id="graphInstructions"><label tabindex="0">NOTE: Selecting a date 
                range greater than six months may lead to excessive wait times</br>and could cause the report generation process to timeout.</label></td>
            </td>
        </tr>
        <%@ include file="pssBaseReportsMenu.jsp" %>
        <tr>
            <td class="leftColumn" tabindex="0"><b>Select Vendor: </b></td>
            <td class="rightColumn"><form:select path="vendorId" alt="Select Vendor">
                <form:option value="-1" label="All Vendors"/>
                <form:options items="${vendors}" itemValue="id" itemLabel="name"/>
            </form:select></td>
        </tr>
        <tr>
            <td colSpan="2" class="centerSpan">
                <form:radiobutton id="version1" path="reportVersionButtonSelection" value="1"  alt="Patient Satisfaction V1.0" tabIndex="0"/><label tabIndex="0"><b> Patient Satisfaction Version 1.0</b></label>
                <form:radiobutton id="version2" path="reportVersionButtonSelection" alt="Patient Satisfaction V2.0"
                value="2" tabIndex="0"/><label tabIndex="0"><b> Patient Satisfaction Version 2.0</b></label>
            </td>
        </tr>
        <tr>
            <td class="centerSpan" colSpan="2" id="graphInstructions"><label tabindex="0" >NOTE: At least one Question Number must be selected</label></td>
        </tr>
        <tr><td class="leftColumn"><label tabindex="0"><b>Include question numbers: </b></label></td>
            <td class="rightColumn" rowSpan="1"> <c:forEach items="${questions}" var="question">
                    <form:checkbox path="questionNumbers" value="${question.choiceNumber}" alt="Include question number ${question.choiceText}"/><label tabIndex="0">${question.choiceText}</label>
                </c:forEach>
            </td>
        </tr>
        <%@ include file="pssCOCSelection.jsp"%>
        <tr>
            <td class="leftColumn"><label  tabindex="0"><b>Display Type: </b></label></td>
            <td class="rightColumn">
                <form:radiobutton id="percentage" path="displayTypeSelection" value="1"  alt="display type Percentage" tabIndex="0"/><label tabIndex="0"> Percentage</label>
                <form:radiobutton id="Mean/stdDev" path="displayTypeSelection" value="2"  alt="display type Mean/Standard Deviation" tabIndex="0"/><label tabIndex="0"> Mean/Standard Deviation</label>
            </td>
        </tr>
    </table>

    <div id="generateReportContainer">
        <input type="submit" class="submitAnchor ui-button" id="generateReportButton"
            value="Generate Report" name="generateReportButton" tabIndex="0" />
    </div>
</form:form>
<%@ include file="pssQuestions.jsp"%>
