<%@ include file="inc_header.jsp"%>


<script type="text/javascript" src="js/manageUsersSearch.js"></script>
<%@ include file="inc_errors.jsp" %>
<link rel="stylesheet" href="css/manageusers.css">
<form:form method="get" action="manageUsersSearchForm.html" commandName="command"  onsubmit="return validateForm()">
		
		<c:if test="${showNoRecordsError}">
			<div id="noUsersFoundErrorWrapper" class="noUsersErrorBlock noUsersError">
				<span class="noUsersError" tabindex="0">Error Message(s):</span>
				<ul id="errorList">		
					<li class="noUsersError" tabindex="0"><span tabindex="0">User not found, Invalid User Id or Name.</span></li>
				</ul>
			</div>
		</c:if>

		<p id="instructionText" tabindex="0">
		Please enter one of the following to search for the user: User ID (i.e. 'DNS') OR user's full Last Name ('Smith') OR user's full Last Name, and full or partial First Name + '%' ('Smith' and 'Jo%') OR a VISN to view the approved or pending users in that VISN
		</p>
		
		<div id="userIdContainer">
			<label for="idInput">User ID:</label>
			<h2 class="required">*</h2>
			<form:input id="idInput" path="id" title="Entry Required If Not Entering Last Name or VISN"/>
		</div>
		
		<div id="orContainer">
			<label tabindex="0">OR</label>
		</div>
		
		<div id="lastNameContainer">
			<label for="lastNameInput">Last Name:</label>
			<h2 class="required">*</h2>
			<form:input id="lastNameInput" path="lastName" title="Entry Required If Not Entering User Id or VISN" />
		</div>
		
		<div id="firstNameContainer">
			<label for="firstNameInput">First Name:</label>	
			<form:input id="firstNameInput" path="firstName"/>
		</div>
		
		<div id="orContainer">
			<label tabindex="0">OR</label>
		</div>
		
		<div id="visnContainer">
			<Label for="visnInput">VISN:</Label>
			<h2 class="required">*</h2>
			<form:select path="selectedVisn" id="visnInput" title="Entry Required If Not Entering User Id or Last Name">
				<form:option value="-1" label="Select VISN" alt="Select VISN Entry Required If Not Entering User Id or Last Name"/>
				<form:options items="${visns}"/>
			</form:select>
		</div>
		
		<input type="submit" class="button" id="search" value = "Search" name="Search" tabIndex="0" onclick="return(validateForm())"/>
		
		<input type="button" class="button" title="Reset" value="Reset" onclick="javascript:resetForm()" />
		<input type="button" class="button" title="Cancel" onclick="javascript:document.location.href='home.html'" value="Cancel" tabIndex="0"/>	

</form:form>
