<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/managescheduledjobs.css" />
<script type="text/javascript" src="js/manageScheduledJobs.js"></script>

<div id="scheduledJobTabContainer">
	<ul>
		<li><a href="#managementTab">Management</a></li>
		<li><a href="#activeTab">Active</a></li>
	</ul>
	<div id="managementTab">
		<section style="margin-top: 10px">
			<table class="stripe dt-head-left dt-body-left hover cell-border"
				id="currentJobs" style="vertical-align: top">
				<thead>
					<tr>
						<th tabindex="0" aria-lable="Press Enter to Sort Job Name">Job Name</th>
						<th tabindex="0"aria-lable="Press Enter to Sort Description">Description</th>
						<th tabindex="0" aria-lable="Press Enter to Sort Schedule">Schedule</th>
						<th tabindex="0" aria-lable="Press Enter to Sort Next Scheduled Date/Time">Next Scheduled Date/Time</th>
						<th tabindex="0" aria-lable="Press Enter to Sort Scheduled Job Status">Scheduled Job Status</th>
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table>
			<button type="button" id="execute" title="Execute"
				onclick="javascript:submitJobExecution()">Execute</button>
			<button type="button" id="config" title="Config"
				onclick="javascript:popupConfigEdit()">Config</button>
			<button type="button" id="schedule" title="Schedule"
				onclick="javascript:popupScheduleEdit()">Schedule</button>
			<button type="button" id="history" title="History"
				onclick="javascript:popupHistory()">History</button>
			<button type="button" id="resumeAll"
				onclick="javascript:submitResumeAll()" title="Resume All">Resume
				All</button>
			<button type="button" id="pauseAll"
				onclick="javascript:submitPauseAll()" title="Pause All">Pause
				All</button>
			<button type="button" id="cancel"
				onclick="document.location.href='home.html'" title="Cancel">Cancel</button>
		</section>
	</div>
	<div id="activeTab">
		<section style="margin-top: 10px"></section>
		<table class="stripe dt-head-left dt-body-left hover cell-border"
			id="activeJobs" style="vertical-align: top; width: 100%">
			<thead>
				<tr>
					<th tabindex="0" aria-lable="Press Enter to Sort Job Name">Job Name</th>
					<th tabindex="0" aria-lable="Press Enter to Sort Start Date/Time">Start Date/Time</th>
					<th tabindex="0" aria-lable="Press Enter to Sort Run By">Run By</th>
					<th tabindex="0" aria-lable="Press Enter to Status">Status</th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<button type="button" id="refreshActive"
			onclick="javascript:refreshActiveJobs()">Refresh</button>
		<button type="button" id="cancelActive"
			onclick="document.location.href='home.html'">Cancel</button>
	</div>

</div>

<div id="configFieldsWrapper" style="display: none"
	title="Config Scheduled Job"  tabIndex="0">
	<table>
		<tr>
			<td class="alignRightNoWrap"><label tabIndex="0">Job Name:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span tabIndex="0" id="configJobName"></span> <input type="hidden"
				id="configJobNameInput" /> <input type="hidden"
				id="configGroupName" /></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap"><label tabIndex="0">Description:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="configJobDescription" tabindex="0"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap"><label tabIndex="0">Next Scheduled Fire Time:</label></td>
			<td class="tenPixelWidth"">&nbsp;</td>
			<td><span  tabindex="0" id="configJobNextFireTime"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap"><label tabIndex="0">Scheduled Job Status:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span tabIndex="0" id="configJobExistingStatus"></span> <input
				type="hidden" id="configJobPreviousStatus" /></td>
		</tr>
		<tr class="topVerticalAlign">
			<td class="alignRightNoWrap"><label tabIndex="0">E-mail Notification List:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><label tabIndex="0">To enter multiple emails, separate each address with a comma
				(,).<br></label><textarea id="configJobEmails" rows="4" cols="50"
					title="Email Notification text area. To enter multiple emails, seperate each address with a comma"></textarea>
			</td>
		</tr>
		<tr>
			<td class="alignRightNoWrap"><label for="configJobStatus" tabIndex="0">Job
					Status</label>:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="configJobStatus" name="Job Status">
					<c:forEach items="${allJobStatuses}" var="status">
						<option value="${status}"><c:out value="${status}" /></option>
					</c:forEach>
			</select></td>
		</tr>
	</table>
</div>

<div id="scheduleFieldsWrapper" style="display: none"
	title="Reschedule Scheduled Job">
	<table>
		<tr>
			<td class="alignRightNoWrap" aria-label="Job Name:"><label tabIndex="0">Job Name:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td tabindex="0"><span id="scheduleJobName"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" aria-label="Description:"><label tabIndex="0">Description:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td  tabindex="0"><span id="scheduleJobDescription"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" aria-label="Next Scheduled Fire Time:">
				<label tabIndex="0">Next Scheduled Fire Time:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td tabindex="0"><span id="scheduleJobNextFireTime"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" aria-label="Scheduled Job Status:">
				<label tabIndex="0">Scheduled Job Status:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td tabindex="0"><span id="scheduleJobExistingStatus"></span></td>
		</tr>
		<tr class="topVerticalAlign">
			<td class="alignRightNoWrap" aria-label="Job Schedule:"><label tabIndex="0">Job Schedule:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td tabindex="0"><span id="scheduleJobScheduleDescriptionSpan"></span>
				<button type="button" id="scheduleJobChange"
					onclick="javascript:popupScheduleChange()">Change</button></td>
		</tr>
	</table>
	<%-- Populated when popping up this dialog --%>
	<input type="hidden" id="scheduleJobNameInput" /> <input type="hidden"
		id="scheduleGroupNameInput" /> <input type="hidden"
		id="scheduleTriggerNameInput" /> <input type="hidden"
		id="scheduleTriggerGroupInput" />
	<%-- Populated when popping up this dialog and also updated when changing the schedule via the popup below --%>
	<input type="hidden" id="scheduleJobCronInput" /> <input type="hidden"
		id="scheduleJobScheduleDescriptionInput" /> <input type="hidden"
		id="scheduleJobScheduleParamsCSV" />
</div>

<div id="scheduleChangeWrapper" style="display: none" title="Schedule"  tabIndex="0">
	<table>
		<tr>
			<td class="0"><label tabIndex="0">Run Frequency:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="scheduleChangeFrequency" alt="Run Frequency">
					<c:forEach items="${allRunFrequencies}" var="runFrequency">
						<option value="${runFrequency.code}"><c:out
								value="${runFrequency.description}" /></option>
					</c:forEach>
			</select></td>
		</tr>
		<tr class="topVerticalAlign">
			<td class="alignRightNoWrap"><label tabindex='0'>Day:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td>
				<div class="scheduleTypeFields" id="dailyWeeklyOptions"
					style="display: none">
					<input type="radio" name="scheduleType" value="1"
						style="display: none" />
					<table>
						<%-- Don't feel like trying to make this DB-driven right now - CPB --%>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="MON" alt="Day Monday"> <label tabIndex="0">Monday</label></td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="TUE" alt="Day Tuesday"> <label tabIndex="0">Tuesday</label></td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="WED" alt="Day Wednesday"> <label tabIndex="0">Wednesday</label></td>
						</tr>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="THU" alt="Day Thursday"> <label tabIndex="0">Thursday</label></td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="FRI" alt="Day Friday"> <label tabIndex="0">Friday</label></td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="SAT" alt="Day Saturday"> <label tabIndex="0">Saturday</label></td>
						</tr>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="SUN" alt="Day Sunday"> <label tabIndex="0">Sunday</label></td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
					</table>
					<input type="hidden" id="scheduleFormDaysOfWeekCSVInput" />
				</div>
				<div class="scheduleTypeFields" id="monthlyOptions"
					style="display: none">
					<table>
						<tr>
							<td><input type="radio" tabindex='0' name="scheduleType" 
								value="dayOfMonth" alt="The day of every month, for example the first day of every month, there is another option to choose, you may use down arrow key to access it"> <label tabIndex="0">The</label> <select
								id="relativeDayOfMonthValue" alt="Day of Month, 1 of 3 options" >
									<option value="1" alt="first day of every Month">first</option>
									<option value="L" alt="last day of every Month">last</option>
									<option value="15" alt="15th day of every Month">15th</option>
							</select> <label tabIndex="0">day of every month</label></td>
						</tr>
						<tr>
							<td><input  type="radio" tabindex='0' name="scheduleType" value="weekDay" alt="The week of every month, for example the first Sunday of each month, there is another option to choose, you may use up arrow key to access it" >
								<label tabIndex="0">The</label> <select id="weekOfMonth" alt="Week of Month, 1 of 4 options"   >
									<option value="1">1st</option>
									<option value="2">2nd</option>
									<option value="3">3rd</option>
									<option value="4">4th</option>
							</select> <select id="dayOfWeek" alt="Day of Week, 1 of 7 options">
									<option value="1">Sunday</option>
									<option value="2">Monday</option>
									<option value="3">Tuesday</option>
									<option value="4">Wednesday</option>
									<option value="5">Thursday</option>
									<option value="6">Friday</option>
									<option value="7">Saturday</option>
							</select> <label tabIndex="0">of every month</label></td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="quarterlyOptions"
					style="display: none">
					<input tabindex='0' type="radio" name="scheduleType" value="3"
						style="display: none"  />
					<%-- ScheduleType.DAY_OF_QUARTER --%>
					<table>
						<tr>
						<%-- add alt to fix 508 issue --%>
							<td><label tabIndex="0">The</label> <select tabindex='0' id="quarterlyDate" alt="The day of every quarter, the first or last day of every quarter" >
									<option value="1">first</option>
									<option value="2">last</option>
							</select> <label tabIndex="0">day of every quarter</label>
							</td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="yearlyOptions"
					style="display: none">
					<table>
						<tr>
							<td><input tabindex='0' type="radio" name="scheduleType"
								value="specificDayOfYear" alt="Every Month on day of the month, for example, every Janurary on 1st day of the month, there is another option to choose, you may use down arrow key to access it"  > <%-- ScheduleType.MONTH_DAY --%>
								<label tabIndex="0">Every </label><select id="yearlyMonth" alt="Month of Year, 1 of 12 options">
									<option value="JAN">January</option>
									<option value="FEB">February</option>
									<option value="MAR">March</option>
									<option value="APR">April</option>
									<option value="MAY">May</option>
									<option value="JUN">June</option>
									<option value="JUL">July</option>
									<option value="AUG">August</option>
									<option value="SEP">September</option>
									<option value="OCT">October</option>
									<option value="NOV">November</option>
									<option value="DEC">December</option>
							</select><label tabIndex="0"> on day</label><select id="yearlyDayOfMonth" alt="Day of Month, 1 of 31 options">
									<option value="1">1st</option>
									<option value="2">2nd</option>
									<option value="3">3rd</option>
									<option value="4">4th</option>
									<option value="5">5th</option>
									<option value="6">6th</option>
									<option value="7">7th</option>
									<option value="8">8th</option>
									<option value="9">9th</option>
									<option value="10">10th</option>
									<option value="11">11th</option>
									<option value="12">12th</option>
									<option value="13">13th</option>
									<option value="14">14th</option>
									<option value="15">15th</option>
									<option value="16">16th</option>
									<option value="17">17th</option>
									<option value="18">18th</option>
									<option value="19">19th</option>
									<option value="20">20th</option>
									<option value="21">21st</option>
									<option value="22">22nd</option>
									<option value="23">23rd</option>
									<option value="24">24th</option>
									<option value="25">25th</option>
									<option value="26">26th</option>
									<option value="27">27th</option>
									<option value="28">28th</option>
									<option value="29">29th</option>
									<option value="30">30th</option>
									<option value="31">31st</option>
							</select> <label tabIndex="0">of the month</label></td>
						</tr>
						<tr>
							<td><input tabindex='0' type="radio" name="scheduleType"
								value="relativeDayOfYear" alt="The week of the month, for example the first Sunday of Janurary, there is another option to choose, you may use up arrow key to access it"  > <%-- ScheduleType.WEEK_DAY_MONTH --%>
								<label tabIndex="0">The </label><select id="yearlyWeekOfMonth" alt="week of month, 1 of 5 options">
									<option value="1">first</option>
									<option value="2">second</option>
									<option value="3">third</option>
									<option value="4">fourth</option>
									<option value="5">last</option>
							</select> <select id="yearlyDayOfWeek" alt="Day of week, 1 of 7 options">
									<option value="SUN">Sunday</option>
									<option value="MON">Monday</option>
									<option value="TUE">Tuesday</option>
									<option value="WED">Wednesday</option>
									<option value="THU">Thursday</option>
									<option value="FRI">Friday</option>
									<option value="SAT">Saturday</option>
							</select><label tabIndex="0"> of </label><select id="yearlyRelativeMonth" alt="Month of Year, 1 of 12 options">
									<option value="1">January</option>
									<option value="2">February</option>
									<option value="3">March</option>
									<option value="4">April</option>
									<option value="5">May</option>
									<option value="6">June</option>
									<option value="7">July</option>
									<option value="8">August</option>
									<option value="9">September</option>
									<option value="10">October</option>
									<option value="11">November</option>
									<option value="12">December</option>
							</select></td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="otherOptions"
					style="display: none">
					<input tabindex='0' type="radio" name="scheduleType" value="7"
						style="display: none">
					<%-- ScheduleType.DATE --%>
					<table>
						<tr>
							<td><input type="text" id="otherDate" size="10" alt="Date, format: MM/DD/YYYY"   />
								<label tabIndex="0">MM/DD/YYYY</label></td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
		<tr>
			<td tabindex='0' alt="Start Time"  class="alignRightNoWrap" ><label tabIndex="0">Start Time:</label></td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="scheduleChangeStartTimeHour" alt="Start Time Hours"  >
					<c:forEach begin="0" end="23" varStatus="loop">
						<option value="${loop.index}"><c:out
								value="${loop.index}" />
						</option>
					</c:forEach>
			</select> <label tabIndex="0">hour(s) </label><select id="scheduleChangeStartTimeMinute" alt="Start Time Minutes"  >
					<c:forEach begin="0" end="59" varStatus="loop">
						<option value="${loop.index}"><c:out
								value="${loop.index}" />
						</option>
					</c:forEach>
			</select> <label tabIndex="0">minute(s)</label></td>
		</tr>
	</table>
</div>

<div id="historyFieldsWrapper" style="display: none"
	title="Scheduled Job History"  tabIndex="0">
	<table>
		<tr>
			<td class="alignRight"><label tabIndex="0"><b>Job Name:</b></label></td>
			<td tabIndex="0" id="historyFieldsJobName"></td>
		</tr>
		<tr>
			<td class="alignRight"><label tabIndex="0"><b>Description:</b></label></td>
			<td tabIndex="0" id="historyFieldsDescription"></td>
		</tr>
		<tr>
			<td class="alignRight"><label tabIndex="0"><b>Next Scheduled Date/Time:</b></label></td>
			<td tabIndex="0" id="historyFieldsNextScheduledTime"></td>
		</tr>
		<tr>
			<td class="alignRight"><label tabIndex="0"><b>Status:</b></label></td>
			<td tabIndex="0" id="historyFieldsStatus"></td>
		</tr>
	</table>
	<table id="jobHistoryTable">
		<thead>
			<tr>
				<th tabindex="0" aria-lable="Press Enter to Sort Start Date/Time">Start Date/Time</th>
				<th tabindex="0" aria-lable="Press Enter to Sort End Date/Time">End Date/Time</th>
				<th tabindex="0" aria-lable="Press Enter to Sort Run By">Run By</th>
				<th tabindex="0" aria-lable="Press Enter to Sort Status">Status</th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
</div>

<div id="historyStatsFieldsWrapper" style="display: none"
	title="Completed Scheduled Job Statistics">
	<table class="completedJobStats">
		<tr>
			<td class="alignRight" style="font-weight: bold"><label tabIndex="0">Name:</label></td>
			<td><span tabIndex="0" id="statsName"></span></td>
		</tr>
		<tr>
			<td class="alignRight" style="font-weight: bold"><label tabIndex="0">Statistics:</label></td>
			<td tabIndex="0"><textarea id="statsDetails" rows="10" cols="50"></textarea></td>
		</tr>
	</table>
</div>
