<%@ include file="inc_header.jsp"%>

<script type="text/javascript">
	//Method to develop the informational message
	//theMsg- the dynamic part of the informational message
	function showInformationMessage(theMsg){

		var elem = document.getElementById("informationMessageDiv");  
 
		if (elem != null && elem != undefined) {
			//Creates the elements of the informational message
			//creates paragraph element- the title "InformationMessage(s):"
			infoMsgParagraph = document.createElement("P");
				titleContent = document.createTextNode("Information Message(s):");
 					infoMsgParagraph.appendChild(titleContent);

			//Creates the list element and adds it to the paragraph element
			infoMsgList = document.createElement("UL");
				infoMsgParagraph.appendChild(infoMsgList);

			//Creates the list item and adds it to the list element
			infoMsgListElem = document.createElement("LI");	
				infoMsgList.appendChild(infoMsgListElem);
		
			//Creates the span element - the text is the dynamic part of the message
			//Adds the span element to the list item
			infoMsgListSpan = document.createElement("SPAN");
				infoMsgListElem.appendChild(infoMsgListSpan);	
					dynamicContent = document.createTextNode(theMsg);
  						infoMsgListSpan.appendChild(dynamicContent);
  
  			//Sets attributes of the paragraph element
  			//Role Alert pulls focus for 508 screen reader when the message is displayed
			infoMsgParagraph.setAttribute("role", "alert");
			infoMsgParagraph.setAttribute("style", "color:green");
			infoMsgParagraph.setAttribute("tabIndex", "0");

			//Sets attributes for list of messages
			infoMsgList.setAttribute("style","list-style-type: disc; color: green; margin-bottom: 10px;");
			infoMsgListElem.setAttribute("tabIndex","0");

			//Sets attributes for the span containing the message
			infoMsgListSpan.setAttribute("id","informationMessage");
			infoMsgListSpan.setAttribute('alt', theMsg);
			infoMsgListSpan.setAttribute("tabIndex", "0");

			//Adds the newly created element to the informationMessageDiv
			infoMsgDiv = document.getElementById("informationMessageDiv");
				infoMsgDiv.appendChild(infoMsgParagraph);
		}
	}
	
	<c:if test="${not empty oneTimeUserNotification}">
	$(function() {
		showInformationMessage("<c:out value="${oneTimeUserNotification}" />")
	})
	</c:if>
</script>

<div id="informationMessageDiv"></div>