<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">
<script type="text/javascript" src="js/reports.js"></script>

<script type="text/javascript">

	$(function() {
        $(reportTitle).focus();
        
		var facilityTotalsResultsTable = $('#facilityTotalsResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			columnDefs: [
				{ targets: 0, "width": "200px"},
				{ targets: '_all', "width": "150px" }
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : '<span tabIndex="0">No data found.</span>',
				"infoEmpty" : '<span tabIndex="0">No data found.</span>'
			}
		});
	})
</script>

<div id="facilityTotalResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="facilityTotalsResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th aria-label="Facility" tabindex="0">Facility</th>
			<th aria-label="VISN" tabindex="0">VISN</th>
			<th aria-label="Total Patients" tabindex="0">Total Patients</th>
			<c:forEach items="${modalities}" var="modality">
				<th aria-label="${modality.description}" tabindex="0">${modality.description}</th>
			</c:forEach>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${facilityTotalReports}" var="report">
			<tr>
				<td tabindex="0">
				<c:choose>
					<c:when test="${report.facilityName == 'Totals'}">
					Totals
					</c:when>
					<c:otherwise>
						<c:choose>
						<c:when test="${fn:length(facilityTotalReports) > 2}">
						<!-- Give the appearance of a link for drilling down into a single facility. -->
						<form:form method="post" action="reports.html" commandName="form" class="inline">
							<input type="hidden" name="drillDownVisn" value="true"/>
							<form:hidden path="visnId" value="${report.visnId}"/>
							<form:hidden path="facilityId" value="${report.facilityId}"/>
							<form:hidden path="modalityCode" value="${modalityCode}"/>
							<form:hidden path="reportEndDate" value="${reportEndDate}"/>
							<form:hidden path="vendorId" value="${vendorId}"/>
							<button type="submit" value="Submit" class="link-button" tabindex="0">
							Facility ${report.facilityId} - ${report.facilityName}</button>
						</form:form>
						</c:when>
						<c:otherwise>Facility ${report.facilityId} - ${report.facilityName}</c:otherwise>
						</c:choose>
					</c:otherwise>
				</c:choose>
				</td>
				<td tabindex="0">${report.visnName}</td>
				<td tabindex="0"><fmt:formatNumber value="${report.patientTotals}" type="number" groupingUsed="true"/></td>
				<c:forEach items="${modalities}" var="modality">
					<td tabindex="0"><fmt:formatNumber value="${report.totalsMap[modality.description]}" type="number"
					groupingUsed="true"/></td>
				</c:forEach>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br> 
<table role="presentation" style="margin-left: auto; margin-right: auto">
     <tr>
         <c:if test="${backButton}">
            <td>
               <%@ include file="censusReportsVisnReturnButton.jsp"%>
            </td>
        </c:if>
        <td>
            <%@ include file="reportsMenuButton.jsp"%>
        </td>
    </tr>
</table>

<%@ include file="vendorReportStatus.jsp"%>