<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/editqir.css">

<script type="text/javascript">
	var isReadOnly = <c:out value="${command.readOnly}" default="false" />
	var isVendor = <c:out value="${userIsVendor}" default="false" />
	var isNationalAdmin = <c:out value="${userIsNationalAdmin}" default="false" />
	var qirStatusTypeCode = "<c:out value="${command.qirStatusType.code}" />"
	var canEditIsDmpIssue = <c:out value="${canEditIsDmpIssue}" default="false" />

	function printQIR() {
		var selected = $('#selectedQIR').val();
		if (selected != null)
			window.open('viewQir.html?qirId=' + selected);
	}

	function confirmCancel() {
		confirmDialog('<span alt="Confirmation Dialog Box All unsaved data will be lost. Do you still want to cancel?" tabIndex="0">All unsaved data will be lost. Do you still want to cancel?</span>', function() {
			document.location.href = "<c:out value="${command.fromPage}" />"
		},{
			okButtonLabel : 'Yes',
			cancelButtonLabel : 'No'
		})
	}

	function confirmWithdraw() {
		
		if(validateForm()) {
			return confirm('Withdraw QIR. This QIR will no longer be available for processing. Do you want to withdraw it?');
		}
		else {
			return false;
		}
	}

	function stripLastCharacter(arg, legalLength) {
		var length = arg.length;
		var retVal = arg.slice(0, (legalLength));

		return retVal;
	}

	$(function() {
		if (!isReadOnly) {
			$(".editButton").show()
		} else {
			disableAttachmentTable()
			$(".editField").prop('disabled', true)
		}

		$("#recAndRemarksArea").html("");
		$("#recAndRemarksHistoryArea").prop("disabled", true)

		$("#editQirContainer").tabs({
			heightStyle : "content"
		})
		
		//Jquery ui tabs are not 508 compliant in their navigation
		//Jquery sets the tabindex of the links to -1 making them unreachable
		//This function will override the tabIndex to 0 whenever the tab
		// button is pressed for navigation
		$(document).keydown(function(e) {
	      	if (e.keyCode === $.ui.keyCode.TAB) {
	      		$('#summary').attr('tabIndex', '0');
	      		$('#recommendations').attr('tabIndex', '0'); 
	      		$('#vendor').attr('tabIndex', '0'); 
	      		$('#attachment').attr('tabIndex', '0'); 
        	}
	    });
		
		$("#isDmpIssueDropDown").change(showDmpIssueTypeContainer)
        
        $("#recAndRemarksHistoryArea").attr("alt", $("#recAndRemarksHistoryArea").val());
        $("#vendorActionsHistory").attr("alt", $("#vendorActionsHistory").val());
        
        var complaintAreaText = $("#complaintArea").val()   
        var complaintAreaLength = complaintAreaText.length
        if(complaintAreaLength == 0){
            $("#complaintArea").attr("alt","Cause of Complaint required field ")
        }else{
            $("#complaintArea").attr("alt","Cause of Complaint required field contains following text: " + complaintAreaText)
        }
            
		$('#complaintArea').on('keyup', function(event) {
		    var text = $("#complaintArea").val()
			var length = text.length
			if(length == 0){
                $("#complaintArea").attr("alt","Cause of Complaint required field ")
            }else{
                $("#complaintArea").attr("alt","Cause of Complaint required field contains following text: " + text)
            }
			$("#causeOfComplaintMessage").text(length + " of 2000 characters used.")
		})
		$('#recAndRemarksArea').on('keyup', function(event) {
			var length = $("#recAndRemarksArea").val().length
			$("#recommendationsMessage").text(length + " of 2000 characters used.")
		})
		$('#vendorActions').on('keyup', function(event) {
			var length = $("#vendorActions").val().length
			$("#vendorActionsMessageCount").text(length + " of 2000 characters used.")
		})
		
		// Call to initialize according to actual isDmpIssue value
		// for selected QIR
		showDmpIssueTypeContainer()

		forceFocusOnErrorMessage()
	})
	
	function showDmpIssueTypeContainer() {  // not sure if used? also done is JSTL. Pretty sure depricated. 
		if ($("#isDmpIssueDropDown").val() === "Y") {
				$("#dmpQirTypeDropDown").css('display', 'inline')
				$("#dmpIssueTypeContainer .required").css('display', 'inline')
		} 
		else {
				$("#dmpQirTypeDropDown").hide()
				$("#dmpQirTypeDropDown").val("-1")
				$("#dmpIssueTypeContainer .required").hide()
		}
	}

	function forceFocusOnErrorMessage() {
		
		if($('#errorsWrapper').is(':visible')){	
			$('#errorsWrapper span:first').focus()	
		}

	}
</script>
<script src="js/editQir.js"></script>
<%@ include file="inc_errors.jsp" %>
<form:form method="post" action="editQir.html" enctype="multipart/form-data">
	<form:input type="hidden" name="fromPage" path="fromPage" value="${command.fromPage}" />
	<div id="instructionsContainer">
		<p tabIndex="0">Note: Copying and pasting text from other documents may cause unexpected characters to be saved in the QIR.</p>
	</div>
	<p tabindex="0" id="title">
		<c:out value="${title}" />
	</p>
	<div id="editQirContainer">
		<ul>
			<li><a id="summary" href="#summaryTab">Summary</a></li>
			<li><a id="recommendations" href="#recAndRemarksTab">Recommendations And Remarks</a></li>
			<li><a id="vendor" href="#vendorActionsTab">Vendor Actions</a></li>
			<li><a id="attachment" href="#attachmentsTab">Attachments</a></li>
		</ul>
		<div id="summaryTab">
			<table role='presentation'>
				<tr valign="top" id="statusContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Status:</label></h4>
						<span tabIndex="0" class="invisibleRequiredFor508">*</span></td>
					<td></td>
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.qirStatusType.name}" />
						</h4></td>
				</tr>
				<tr valign="top" id="tnContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Tracking
							Number:</label></h4></td>
					<td></td>
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.id}" />
						</h4> <input id="selectedQIR" name="selectedQIR" type="hidden"
						value="${fn:escapeXml(command.id)}" path="selectedQIR" class="editField" /></td>
				</tr>
				<tr valign="top" id="headlineContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Headline:</label></h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.headline != null}">
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.headline}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="submittedDateContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Submitted
							Date:</label></h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.submittedDateAsString != null}">
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.submittedDateAsString}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="submittedByContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Submitted
							By:</label></h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.submittedByName != null}">
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.submittedByName}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="facilityContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Facility:</label></h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.facilityNumAndName != null}">
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.facilityNumAndName}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="typeOfComplaintContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">Type of Complaint:</label></h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.qirType.label != null}">
					<td><h4 tabIndex="0" id="value">
							<c:out value="${command.qirType.label}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="isDmpIssueContainer">
					<td align="right" class="fieldLabel"><h4><label tabIndex="0">DMP Issue:</label></h4></td>
					<c:choose>
						<c:when test="${canEditIsDmpIssue}">
							<span class="invisibleRequiredFor508" tabIndex="0">*</span>
							<td><h2 class="required" tabIndex="0">*</h2></td>
							<td>
							<form:select path="isDmpIssue" id="isDmpIssueDropDown" title="DMP Issue required field"
								cssClass="editField" alt="DMP Issue required field" required="true">
								<form:option value="S" label="Select" />
								<form:option value="Y" label="Yes" />
								<form:option value="N" label="No" />
							</form:select>
							</td>
						</c:when>
						<c:otherwise>
							<td></td>
							<td>
							<c:if test="${command.isDmpIssue == 'N'}">
								<h4 id="value"><label tabIndex="0">No</label></h4>
								<form:hidden path="isDmpIssue" value="${command.isDmpIssue}"/>
							</c:if>
							<c:if test="${command.isDmpIssue == 'Y'}">
								<h4 id="value"><label tabIndex="0">Yes</label></h4>
								<form:hidden path="isDmpIssue" value="${command.isDmpIssue}"/>
							</c:if>
							</td>
						</c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="dmpIssueTypeContainer">
				<td align="right" class="fieldLabel"><h4><label tabIndex="0">DMP Issue Type:</label></h4> 
				
				<span class="invisibleRequiredFor508" tabIndex="0">*</span></td>
				<c:choose>
					<c:when test="${canEditIsDmpIssue}">
						<td><h2 class="required" tabIndex="0">*</h2></td>
						<td>
						<c:if test="${canEditIsDmpIssue}">
							<form:select path="selectedDmpQirTypeId" id="dmpQirTypeDropDown" tabindex="0"
								cssClass="editField" alt="DMP Issue Type required field" required="true">
								<form:option value="-1" label="Select" />
								<form:options items="${command.dmpQirTypes}" />
							</form:select>
						</c:if>
						</td>
					</c:when>
					<c:otherwise>
						<td></td>
						<td><h4 id="value" tabindex="0">
						<c:out value="${dmpType}"></c:out>
						</h4>
						<form:hidden path="selectedDmpQirTypeId" value="${dmpTypeId}"/></td>
					</c:otherwise>
				</c:choose>
			</tr>
			<tr valign="top" id="orderNumberContainer">
				<td align="right" class="fieldLabel"><h4><label tabIndex="0">Contract
						or Purchase Order Number:</label></h4></td>
				<td></td>
				<c:choose>
				<c:when test = "${command.purchaseOrderNumber != null}">
					<td><h4 tabIndex="0" id="value">
						<c:out value="${command.purchaseOrderNumber}" />
					</h4></td>
				</c:when>
				<c:otherwise><td></td></c:otherwise>
				</c:choose>
			</tr>
			<tr valign="top" id="deviceModelContainer">
				<td align="right" class="fieldLabel"><h4><label tabIndex="0">Device
						Model:</label></h4></td>
				<td></td>
				<c:choose>
				<c:when test = "${command.deviceType.label != null}">
				<td><h4 tabIndex="0" id="value">
						<c:out value="${command.deviceType.label}" />
					</h4></td>
				</c:when>
				<c:otherwise><td></td></c:otherwise>
				</c:choose>
				
			</tr>
			<tr valign="top" id="vendorContainer">
				<td align="right" class="fieldLabel"><h4><label tabIndex="0">Vendor:</label></h4></td>
				<td></td>
				<c:choose>
				<c:when test = "${command.vendor.label != null}">
				<td><h4 tabIndex="0" id="value">
						<c:out value="${command.vendor.label}" />
					</h4></td>
				</c:when>
				<c:otherwise><td></td></c:otherwise>
				</c:choose>
			</tr>
			<tr valign="top" id="serialNumberContainer">
				<td align="right" class="fieldLabel"><h4><label tabIndex="0">Serial
						Number:</label></h4></td>
				<td></td>
				<c:choose>
				<c:when test = "${command.serialNumber != null and not empty command.serialNumber }">
				<td><h4 tabIndex="0" id="value">
						<c:out value="${command.serialNumber}" />
					</h4></td>
				</c:when>
				<c:otherwise><td></td></c:otherwise>
				</c:choose>
			</tr>
			<tr valign="top" id="complaintContainer">
				<c:choose>
					<c:when test="${userIsVendor}">
						<td align="right" class="fieldLabel"><label class="ihtaLabel" tabIndex="0">Cause of Complaint:</label></td>
						<td></td>
						<td><form:textarea tabIndex="0" id="complaintArea" path="complaint" maxlength="2000" 
								rows="4" cols="75" disabled="true" cssClass="editField"/>
							<p id="causeOfComplaintMessage"></p></td>
					</c:when>
					<c:otherwise>
						<td align="right" class="fieldLabel">
						<h4 class="ihtaLabel"><label tabIndex="0">Cause of Complaint:</label></h4>
						<span class="invisibleRequiredFor508" tabIndex="0">*</span></td>
						<td><h2 class="required" tabIndex="0">*</h2></td>
						<td>
							<form:textarea id="complaintArea" path="complaint" tabindex="0"
								rows="4" cols="75" disabled="false" cssClass="editField"/>
							<p tabIndex="0" id="causeOfComplaintMessage"></p>
						</td>
					</c:otherwise>
				</c:choose>
			</tr>
		</table>
			
			

		</div>
		<div id="recAndRemarksTab">
			<table>
				<c:if test="${enableRemarks}">
					<tr valign="top">
						<td align="right" class="fieldLabel">
						<label tabindex="0" class="ihtaLabel" for="recAndRemarksArea">Recommendations And Remarks:</label></td>
						<td><h2 tabIndex="0" class="required">*</h2></td>
						<td><form:textarea id="recAndRemarksArea" path="remarks" alt="recommendations and remarks is required field" maxlength="2000"
								rows="10" cols="75" cssClass="editField" tabIndex="0" />
							<p tabIndex="0" id="recommendationsMessage"></p></td>
					</tr>
				</c:if>
				<tr valign="top">
					<td align="right" class="fieldLabel">
					<label tabindex="0" class="ihtaLabel" for="recAndRemarksHistoryArea">Recommendations And Remarks History:</label>
					</td>
					<td></td>
					<td  tabIndex="0"><form:textarea id="recAndRemarksHistoryArea"
							path="remarksHistory" rows="10" cols="75" cssClass="editField" tabIndex="0" alt="remarksHistory"/></td>
				</tr>
			</table>
		</div>
		<div id="vendorActionsTab">
			<table>
				<c:if test="${showVendorResponseDueDate}">
					<tr valign="top">
						<td align="right" class="fieldLabel" tabIndex="0"><h4
								style="color: Green;"><label tabIndex="0">Vendor Response Due:</label></h4></td>
						<td></td>
						<td tabIndex="0"><h4 id="value" tabindex="0" style="color: Green;">
								<c:out value="${vendorResponseDueDateAsString}" />
							</h4></td>
					</tr>
				</c:if>
				<c:if test="${userIsVendor}">
					<tr valign="top" id="vendorActionsContainer">
						<td align="right" class="fieldLabel">
						<label tabindex="0" class="ihtaLabel" for="vendorActions">Vendor Actions:</label>
						</td>
						<td tabIndex="0"><h2 class="required">*</h2></td>
						<td tabIndex="0"><form:textarea id="vendorActions" path="vendorActions"
								rows="10" cols="75" cssClass="editField"  alt="Vendor Actions required field"/>
							<p tabIndex="0" id="vendorActionsMessageCount"></p></td>
					</tr>
				</c:if>
				<tr valign="top" id="vendorActionsHistoryContainer">
					<td align="right" class="fieldLabel">
					<label tabindex="0" class="ihtaLabel" for="vendorActionsHistory">Vendor Actions History:</label>
					</td>
					<td></td>
					<td tabIndex="0"><form:textarea id="vendorActionsHistory"
							path="vendorActionsHistory" rows="10" cols="75" disabled="true"
							cssClass="editField" tabIndex="0" alt="vendorActionsHistory"/></td>
				</tr>
			</table>
		</div>
		<div id="attachmentsTab">
			<div id="informationMessageContainer">
				<h5 id="informationMessage" tabindex="0">The total size of all
					attachments should not exceed 5 MB.</h5>
			</div>
			<div id="attachmentsContainer" style="display: inline-block">
				<c:set var="attachmentTableInitialValues"
					value="${command.attachments}" scope="request" />
				<jsp:include page="inc_attachmentTable.jsp">
					<jsp:param name="showDelete" value="false" />
				</jsp:include>
			</div>
		</div>
	</div>

	<div id="buttonContainer">
	
		<c:if test="${canSubmit}">
		<input type="submit" class="submitAnchor button editButton" id="Update"
			value="Update" name="Update" onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canApprove}">
			<input type="submit" class="submitAnchor button editButton" id="Approve"
				value="Approve" name="Approve"  onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canWithdraw}">
			<input type="submit" class="submitAnchor button editButton" id="Withdraw"
				value="Withdraw" name="Withdraw"
				onclick="return(confirmWithdraw());" />
		</c:if>
		<c:if test="${canAgree}">
			<input type="submit" class="submitAnchor button editButton" id="Agree"
				value="Agree" name="Agree" />
		</c:if>
		<c:if test="${canReply}">
			<input type="submit" class="submitAnchor button editButton" id="Reply"
				value="Reply" name="Reply" onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canClose}">
			<input type="submit" class="submitAnchor button editButton" id="Close"
				value="Close" name="Close" onclick="return(validateForm())" />
		</c:if>
		<input type="button" class="submitAnchor button" id="pdf" value="PDF" name="PDF"
			onclick="printQIR()" /> <input type="button" class="submitAnchor button"
			value="Cancel"
			onclick="confirmCancel()" />
	</div>
	
	<!-- Add all hidden fields that will always be needed, like id -->
	<form:hidden path="id"/>
	<form:hidden path="headline"/>
	<c:if test="${userIsVendor}">
		<%-- If the user is a vendor, the cause of complaint text is disabled and therefore does not get bound by Spring --%>
		<form:hidden path="complaint"/>
	</c:if>
	
</form:form>

