<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/userregistration.css">
<link rel="stylesheet" href="css/denyregistration.css">

<script type="text/javascript">
	function confirmCancel() {
		return confirm("All unsaved data will be lost. Do you still want to cancel?")
	}

	$(function() {
		$("#datepicker").datepicker()
		$("#assignedUserGroup").val('20071')
		$("#assignedUserGroup").hide()
		$("#assignedUserGroupText").text('VA User')

		$("#assignedRegistrationStatus").val('20083')
		$("#assignedRegistrationStatus").hide()
		$("#assignedRegistrationStatusText").text('Denied')

		$("#assignedJobDescription").prop("disabled", true)
		
		$('#my-select').multiSelect({
			selectableHeader : "<div class='custom-header'>Available</div>",
			selectionHeader : "<div class='custom-header'>Assigned</div>"
		})
		
		$('#inactive').change(function() {
			if ($('#inactive').is(':checked')) {
				$('#inactivateDate').css("display", "block")
				$('#inactivateReason').css("display", "block")
			} else {
				$('#inactivateDate').css("display", "none")
				$('#inactivateReason').css("display", "none")
			}
		})

		$('#addRole').click(function() {
			var result = new Array()
			$('#availableRoles option:selected').each(function() {
				result.push($this.val())
			})
			alert("" + result)
			return false
		})
	})
</script>

<form:form method="post" action="manageRegistrations.html">

	<div id="userName">
		<h4 tabIndex="0">User Name:</h4>
		<h4 id="value">
			<c:out value="${command.fullName}" />
		</h4>
	</div>
	<div id="userId">
		<h4 tabIndex="0">User ID:</h4>
		<h4 id="value">
			<c:out value="${command.userName}" />
		</h4>
	</div>
	<div id="email">
		<h4 tabIndex="0">E-mail:</h4>
		<h4 id="value">
			<c:out value="${command.email}" />
		</h4>
	</div>
	<div id="phone">
		<h4 tabIndex="0">Phone:</h4>
		<h4 id="value">
			<c:out value="${command.phone}" />
		</h4>
	</div>
	<div id="userGroupContainer">
		<label tabindex="-1" class="ihtaLabel" for="assignedUserGroup">User Group:</label>
		<h2 class="required">*</h2>
		<form:select id="assignedUserGroup" path="assignedUserGroup"
			items="${command.userGroups}">
		</form:select>
	</div>
	<div id="registrationStatusContainer">
		<label tabindex="-1" class="ihtaLabel" for="assignedRegistrationStatus">Registration Status:</label>
		<h2 class="required">*</h2>
		<form:select id="assignedRegistrationStatus"
			path="assignedRegistrationStatusId"
			items="${command.registrationStatusMap}">
		</form:select>
	</div>
	<div id="registrationDeniedContainer">
		<label tabindex="-1" class="ihtaLabel" for="assignedRegistrationDenied">Registration Denied Reason:</label>
		<h2 class="required">*</h2>
		<form:select id="assignedRegistrationDenied"
			path="registrationDeniedReasonId"
			items="${command.registrationDeniedReasons}">
		</form:select>
	</div>
	<div id="jobDescriptionContainer">
		<label tabindex="-1" class="ihtaLabel" for="assignedJobDescription">Job Description:</label>
		<h2 class="required">*</h2>
		<form:select id="assignedJobDescription"
			path="assignedJobDescriptionId" items="${command.jobDescriptionMap}">
		</form:select>
	</div>
	<div id="assignedVisnContainer">
		<label tabindex="-1" class="ihtaLabel" for="assignedVisnId">Assigned VISN:</label>
		<h4 tabIndex="0">Assigned VISN:</h4>
		<form:select path="assignedVisnId" items="${command.visns}">
			<option value="-1">Select VISN</option>
		</form:select>
	</div>
	<div id="assignedFacilityContainer">
		<label tabindex="-1" class="ihtaLabel" for="facilitiesId">Assigned Facility:</label>
		<form:select id="facilitiesId" path="facilitiesId" items="${command.facilities}">
		</form:select>
	</div>
	<div id="vendor">
		<h4 tabIndex="0">Vendor:</h4>

		<form:select path="selectedVendorId" items="${command.vendors}">
		</form:select>

	</div>
	<div id="availableRoles">
		<label tabindex="-1" class="ihtaLabel" for="my-select">Roles:</label>
		<div>
			<form:select multiple="multiple" id="my-select" name="my-select"
				path="assignedRoles" items="${command.allRolesMap}">
			</form:select>
		</div>
	</div>
	<div id="lockedContainer">
		<label tabindex="-1" class="ihtaLabel" for="locked">Locked:</label>
		<input type="checkbox" id="locked" name="locked" path="locked">
	</div>
	<div id="inactivate">
		<label tabindex="-1" class="ihtaLabel" for="inactive">Inactive:</label>
		<input type="checkbox" id="inactive" name="inactive" path="inactive" />
	</div>
	<div id="inactivateDate">
		<label tabindex="-1" class="ihtaLabel" for="datepicker">Inactivation Date:</label>
		<h2 class="required">*</h2>
		<form:input type="text" id="datepicker"
			path="inactivationDateAsString" />
	</div>
	<div id="inactivateReason">
		<label tabindex="-1" class="ihtaLabel" for="InactiveReasonId">Inactivation Reason:</label>
		<h2 class="required">*</h2>
		<form:select id="inactiveReasonId" path="inactiveReasonId"
			items="${command.inactiveReasons}">
		</form:select>
	</div>

	<div id="buttonContainer">
		<input type="submit" class="button" title="Submit" id="submit" value="Submit"
			name="Submit"> <input type="submit" class="button" title="Reset" id="reset"
			value="Reset" name="denyReset"> <input type="submit"
			class="button" title="Cancel" id="cancel" value="Cancel" name="Cancel"
			onclick="return(confirmCancel());" />
	</div>
</form:form>