
function validateForm() {
	var errors = new Array()
	
	var userEnteredRoleName = $.trim($("#roleName").val().toLowerCase());
	
	if (userEnteredRoleName == '') {
		errors.push({ field : 'name', message : 'Role Name is required.' })
	} else if (userEnteredRoleName.length < 5) {
		errors.push({ field : 'name', message : 'Role Name must be at least 5 characters long.'})
	}
	
	if ($("div[data-role-name='"+userEnteredRoleName+"']").length>0) {
		errors.push({ field : 'name', message : 'Role with same name already exists.'})
	}
	
	var userEnteredDescription = $.trim($("#description").val());
	
	if (userEnteredDescription == '') {
		errors.push({ field : 'description', message : 'Description is required.'})
	}  else if (userEnteredDescription.length < 5) {
		errors.push({ field : 'description', message : 'Description must be at least 5 characters long.' })
	}
	
	if (errors.length > 0) {
		showErrors(errors)
		forceFocusOnInfoMessage()
		return false
	}
	
	// Discover all currently checked checkboxes 
	var selectedPermissions = [];
	$('#permissionsContainer input:checked').each(function() {
		selectedPermissions.push($(this).attr('value'));
	});
	
	if (selectedPermissions.length < 1) {
		confirmDialog('Do you want to save this role without assigning any permissions?', function() {
			$("#roleForm")[0].submit()
		},{
			okButtonLabel : 'Yes',
			cancelButtonLabel : 'No'
		})
		return false
	}
	
	return true
}

function forceFocusOnInfoMessage() {

	if($('#errorsWrapper').is(':visible')){	
		$('#errorsWrapper span:first').focus()	
	}

}

function cancelRoleUpdate() {
	confirmDialog('All of the unsaved data will be lost. Do you still want to cancel?', function() {
		document.location.href = 'roleSelect.html'
	},{
		okButtonLabel : 'Yes',
		cancelButtonLabel : 'No'
	})
}

function resetForm() {
	location.reload()
}