$(function() {
	$(".errorBlock").hide()
	forceFocusOnInfoMessage()
})

function showNoRecordsError() {
	var errors = new Array()
	errors.push({ field : 'name', message : 'User not found, Invalid User Id or Name.' })
	showErrors(errors)
	
}

function hideShowNoRecordsReturned() {

	var isVisible = $('#noUsersFoundErrorWrapper').is(':visible')
	
	if(isVisible) {
		$('#noUsersFoundErrorWrapper').css('display', 'none')
	}	
	
}


function validateForm() {
	var errors = new Array()
	
	var userId = $.trim($("#idInput").val());
	var lastName = $.trim($("#lastNameInput").val());
	var visn = $("#visnInput").val();
	
	hideShowNoRecordsReturned()
	
	if (visn == '-1') { // if visn is selected, do not check other fields
		if (userId == '' && lastName == '') {
			errors.push({ field : 'name', message : 'User ID, Full Last Name or VISN Selection is required.' })
		} 
		
		if (userId.length > 0 && lastName.length > 0) {
			errors.push({ field : 'description', message : 'Multiple search criteria used.  Please enter either User Id or User Name search, but not both.'})
		} 
	}
	if (errors.length > 0) {
		showErrors(errors)
		forceFocusOnInfoMessage()
		return false
	}
	
	
	
	return true
}

function forceFocusOnInfoMessage() {

	if($('#noUsersFoundErrorWrapper').is(':visible')){	
		$('#noUsersFoundErrorWrapper span:first').focus()	
	}
	
	if($('#errorsWrapper').is(':visible')){
		$('#errorsWrapper span:first').focus()
	}
}

function resetForm() {
	$("#idInput").val('')
	$("#lastNameInput").val('')
	$("#firstNameInput").val('')
	$("select option:first-child").prop("selected", "selected");
	$(".errorBlock").hide()
}