var confirmationDialogInitialized = false
var confirmationDialogCallback = null

function initializeConfirmationDialog() {
	if (confirmationDialogInitialized)
		return
	
	$("#confirmationDialog").dialog({
		autoOpen: false,
		modal: true,
		show: 'slide',
		draggable: true,
		resizable:true,
		width: 550,
		buttons : [{
			id : "confirmDialogSubmit",
			text : "OK",
			click : function() {
				$(this).dialog('close')
				confirmationDialogCallback()
			}
		}, {
			id : "confirmDialogCancel",
			text : "Cancel",
			click : function() {
				$(this).dialog('close')
				if (confirmationDialogCancelCallback)
					confirmationDialogCancelCallback()
			}
		}]
	})
	
	confirmationDialogInitialized = true
}

/**
 *  Displays Confirmation Dialog 
 */
function confirmDialog(messageToDisplay, acceptanceCallback, options) {
	initializeConfirmationDialog()
	
	var finalOpts = $.extend({}, {
		cancelCallback : null,
		title : null,
		width : 550,
		height : 200,
		okButtonLabel : 'OK',
		cancelButtonLabel : 'Cancel'
	}, options)
	
	confirmationDialogCallback = acceptanceCallback
	confirmationDialogCancelCallback = finalOpts.cancelCallback
	
	$('#confirmationDialog').dialog('option', 'width', finalOpts.width)
	$('#confirmationDialog').dialog('option', 'height', finalOpts.height)
	$("#confirmationDialogMessage").empty().html(messageToDisplay)
	
	$('#confirmationDialog').dialog('option', 'title', finalOpts.title ? escapeHTML(finalOpts.title) : 'Confirmation')
	$("#confirmDialogSubmit").button("option", "label", finalOpts.okButtonLabel);
	$("#confirmDialogCancel").button("option", "label", finalOpts.cancelButtonLabel);
	$("#confirmationDialog").dialog("open")
}