/********************************************************************
 * Copyriight 2008 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.util.date;

import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;

/**
 * Wrapper object for tracking a Date with an associated TimeZone. Useful for
 * "tagging" a TimeZone to always format a date with (eg, the TimeZone the Date
 * was entered in).
 * 
 * Oct 10, 2008
 * 
 * @author       DNS
 */
public class DateWithTimeZone implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3157346989376113550L;
	private Date date;
	private TimeZone timeZone;

	public DateWithTimeZone() {
	}

	public DateWithTimeZone(Date date, TimeZone timeZone) {
		this.date = date;
		this.timeZone = timeZone;
	}

	/**
	 * @return the date
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * @param date
	 *            the date to set
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * @return the timeZone
	 */
	public TimeZone getTimeZone() {
		return timeZone;
	}

	/**
	 * @param timeZone
	 *            the timeZone to set
	 */
	public void setTimeZone(TimeZone timeZone) {
		this.timeZone = timeZone;
	}

	public boolean equals(DateWithTimeZone tzDate) {
		if (tzDate == null && date == null) {
			return true;
		}
		if (tzDate != null && tzDate.date != null && date != null) {
			return date.equals(tzDate.date);
		}
		return false;
	}

	public String toString() {
		return TimeZoneUtils.convertDateToTimeZone(this);
	}
}
