/********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.trigger;

import org.apache.commons.lang.enums.Enum;

/**
 * Initial javadoc for class TriggerIdentity. TODO - Add content here
 * 
 * Created Aug 22, 2005 11:51:45 PM
 * 
 * @author DNS   DNS
 */
public interface TriggerIdentity {
	public static final String NAME_DELIMITER = "-";

	public class TargetType extends Enum {

		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3345327685426893529L;

		protected TargetType(String name) {
			super(name);
		}
	}

	public class DestinationType extends Enum {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3923553881353442950L;

		public static final DestinationType DEFAULT = new DestinationType("DEFAULT");
		public static final DestinationType BATCH_PROCESS = new DestinationType("BATCH_PROCESS");
		public static final DestinationType REPORT = new DestinationType("REPORT");
		public static final DestinationType LOG4J = new DestinationType("LOG4J");

		protected DestinationType(String name) {
			super(name);
		}
	}

	public class DispatchType extends Enum {

		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6603540578581101769L;

		protected DispatchType(String name) {
			super(name);
		}
	}

	public class EntityType extends Enum {

		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -1199640916773022849L;

		protected EntityType(String name) {
			super(name);
		}
	}

	public String getName();

	public TargetType getTargetType();

	public DestinationType getDestinationType();

	public DispatchType getDispatchType();

	public EntityType getEntityType();

	public boolean isUsedForConsumerRouting();
}
