/*********************************************************************
 * Copyriight 2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.pagination;

// Java Classes
import java.io.Serializable;
import java.util.List;

import gov.va.med.fw.service.ServiceException;

/**
 * An interface that defines a service that is able to perform paginated
 * searches.
 * 
 * @author Andrew Pach & DNS
 * @version 3.0
 */
public interface PaginatedSearchService extends Serializable {
	/**
	 * Perform a paginated search based on the passed in query information. The
	 * paginated service should update the following attributes on
	 * SearchQueryInfo before returning:
	 * <p>
	 * 1) totalNumberOfEntries: This should be set with the total number of
	 * records that match the search criteria.
	 * <p>
	 * 2) searchTypePerformed: This should be set to either
	 * SearchQueryInfo.SEARCH_READ_ALL if all records were returned or
	 * SEARCH_SINGLE_PAGE if only one pages worth of records were read.
	 * <p>
	 * 3) sortPerformed: This should be set to true if the service performed a
	 * sort or false if not. This gives an indication to the caller whether they
	 * need to perform a post-query sort or not for search services that don't
	 * handle sorting.
	 * <p>
	 * 4) sortColumnNotSupported: This should be set to true if a sort was
	 * requested on a sort column that is not supported by the search service
	 * (e.g. a database field is not directly tied to a UI column) or false
	 * otherwise.
	 * 
	 * @param searchQueryInfo
	 *            The query information that define search parameters for the
	 *            query.
	 * @throws ServiceException
	 *             if any problems were encountered performing the search.
	 * 
	 * @return The list of records that meet the search criteria.
	 */
	public <T> List<T> search(SearchQueryInfo<T> searchQueryInfo) throws ServiceException;
}
