/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.service.jms;

// Java classes
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;

/**
 * 
 */
public interface MessageProducerService extends Serializable {
	public void send(MessagePayload payload) throws MessageProducerException;

	public void send(Serializable payload) throws MessageProducerException;

	public void send(Serializable payload, Map<String, Serializable> headerProperties)
			throws MessageProducerException;

	public void send(Serializable payload, Properties headerProperties)
			throws MessageProducerException;
	
	public void sendToAll(MessagePayload payload) throws MessageProducerException;

	public void sendToAll(Serializable payload) throws MessageProducerException;

	public void sendToAll(Serializable payload, Map<String, Serializable> headerProperties)
			throws MessageProducerException;

	public void sendToAll(Serializable payload, Properties headerProperties)
			throws MessageProducerException;
}