/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.fw.service.config;

import org.springframework.context.ApplicationContext;

import gov.va.med.fw.service.AbstractComponent;

/**
 * Utilizes <code>ContextSingletonBeanFactoryLocator</code> class to load a
 * shared context in a single EAR file. This class is thread-safe and
 * syynchronization is handled in <code>ContextSingletonBeanFactoryLocator<code>
 * 
 * @author DNS
 */
public class SingletonApplicationContext extends AbstractComponent {

	/**
	 * An instance of instance
	 */
	private static SingletonApplicationContext instance = null;

	/**
	 * A default constructor
	 */
	protected SingletonApplicationContext() {
		super();
	}

	/**
	 * Returns a single instance of this class
	 * 
	 * @return
	 */
	public static SingletonApplicationContext getInstance() {

		
		synchronized (SingletonApplicationContext.class) {
			if (instance == null) {
					instance = new SingletonApplicationContext();
			}
		}
		return instance;
	}

	/**
	 * Get bean with specified id
	 * 
	 * @param beanName
	 * @return
	 */
	public Object getBean(String beanName) {
		return getApplicationContext().getBean(beanName);
	}

	/**
	 * 
	 * @param beanId
	 * @param clazz
	 * @return
	 */
	public Object getBean(String beanId, Class clazz) {
		return getApplicationContext().getBean(beanId, clazz);
	}

	// to be deleted methods

	public void setSingletonContext(
			org.springframework.context.ConfigurableApplicationContext context) {

	}

	public ApplicationContext getSingletonContext() {
		return getApplicationContext();
	}
}