package gov.va.med.fw.service.config;

import java.util.TimeZone;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.VersionInfo;

public interface EnvironmentParamService {
	public boolean isDataClean();

	public boolean isLocalEnv();

	public boolean isDevIntEnv();

	public boolean isSqaEnv();

	public boolean isProdEnv();

	/**
	 * Determines if site is supported based on the current environment.
	 * 
	 * @return boolean indicating if site is supported
	 * 
	 * @throws ServiceException
	 */
	// public boolean isSupportedFacility(VAFacility facility) throws
	// ServiceException;
	public VersionInfo getVersion() throws ServiceException;

	public String getLdapGroupsRoot() throws ServiceException;

	public String getDeployedEnvironment();

	public TimeZone getReportingTimeZone();
	
	public String getLogoutTimeoutUrl();
	
	public String getLogoutManualUrl();
}
