package gov.va.med.fw.service.config;

/**
 * Allows for ordering of configuration items during execution (eg, Spring
 * post-processors). Those with the same priority order will execute
 * arbitrarily.
 * 
 * @author DNS   DNS
 * 
 */
public class ConfigPriorityOrder {
	/** Highest priority which means it will execute first */
	public final static int HIGH = Integer.MIN_VALUE;

	/** Medium priority which means it will execute after the HIGH */
	public final static int MEDIUM = 0;

	/** Lowest priority which means it will execute after both HIGH and MEDIUM */
	public final static int LOW = Integer.MAX_VALUE;
}
