/********************************************************************
 Copyriight 2004 VHA. All rights reserved
 ********************************************************************/

// Package
package gov.va.med.fw.service;

/**
 * A base exception for all service requests. This exception is thrown if a
 * request is not fulfilled successfully.
 * 
 * @author Vu Le
 * @version 1.0
 */
public class ServiceConfigurationException extends ServiceException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -7849100514442435438L;
	/**
	 * A class that originate an exception
	 */
	private Class originator = null;

	/**
	 * Creates new <code>ServiceException</code> without detail message.
	 */
	public ServiceConfigurationException() {
		super();
	}

	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message.
	 * 
	 * @param msg
	 *            the detail message.
	 */
	public ServiceConfigurationException(String msg) {
		super(msg);
	}

	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 */
	public ServiceConfigurationException(String msg, Throwable cause) {
		super(msg, cause);
	}

	/**
	 * Constructs an <code>ServiceException</code> with the specified detail
	 * message and a caused exception
	 * 
	 * @param msg
	 *            the detail message.
	 * @param cause
	 *            the caused exception
	 * @param originator
	 *            the class that originates an exception
	 */
	public ServiceConfigurationException(String msg, Throwable cause, Class originator) {
		super(msg, cause);
	}

	/**
	 * Returns a class that originates an exception
	 * 
	 * @return Returns the originator.
	 */
	public Class getOriginator() {
		return originator;
	}

	/**
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		StringBuilder info = new StringBuilder(super.getMessage());
		info.append(" Cause: " + this.getCause());

		if (this.originator != null) {
			info.append(" Origination: " + this.getOriginator());
		}
		return info.toString();
	}
}