/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.TimeZone;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

/**
 * UserPrincipal, extends from Principal, UserDetails and provides user profile
 * and UserPrincipal also contains a set of GrantedAuthorities or roles
 * 
 * @author DNS
 * @version 1.0
 */
public interface UserPrincipal<T> extends UserDetails {

	/**
	 * First name of the user
	 * 
	 * @return String - first name of a user
	 */
	public String getFirstName();

	/**
	 * Middle name of the user
	 * 
	 * @return String - middle name of a user
	 */
	public String getMiddleName();

	/**
	 * Last name of the user
	 * 
	 * @return String - Last name of a user
	 */
	public String getLastName();

	/**
	 * @return String - password of the user
	 */
	public String getPassword();

	/**
	 * Check whether is user the anonymous user or not.
	 * 
	 * @return true if anonymous, false otherwise.
	 */
	public boolean isAnonymous();

	/**
	 * Get generic Authority object that implements GrantedAuthority Interface
	 * 
	 * @return
	 */
	public Collection<? extends GrantedAuthority> getAuthorities();

	/**
	 * Get the user credentials information for this Principal
	 * 
	 * @return UserCredentials
	 */
	public UserCredentials getUserCredentials();

	/**
	 * Verify whether user has the specified authority granted
	 * 
	 * @param permission
	 * @return
	 */
	public boolean isPermissionGranted(String permission);

	/**
	 * Verify whether user has one of the specified authority granted
	 * 
	 * @param permissions
	 * @return
	 */
	public boolean isRoleGranted(Collection permissions);

	/**
	 * Get users full name for display purposes
	 * 
	 * @return
	 */
	public String getFullName();

	public boolean isInactive();

	public Date getInactiveDate();

	public String getInactiveMessage();

	public boolean isAccountLocked();

	public TimeZone getCurrentTimeZone();

	public void setCurrentTimeZone(TimeZone timeZone);

	public String getDepartment();

	public String getTitle();

	public String getDescription();

	public String getOffice();

	public String getTelephoneNumber();

	public String getEmail();

	public Set<String> getLdapRoles();
}