/********************************************************************
 * Copyriight 2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.fw.security;

import java.io.Serializable;
import java.util.Set;

/**
 * RolePrincipal, extends from Principal, provides methods to access the role
 * information. Also provide methods to access the UserPrincipal's belong to
 * this Role.
 * 
 * @see gov.va.med.fw.security.UserPrincipal
 * 
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public interface RolePrincipal extends Principal, Serializable {
	/**
	 * A Set of UserPrincipal's that have this role. If no user belong to
	 * RolePrincipal, this method returns an empty Set.
	 * 
	 * @return Set of UserPrincipal, never null
	 */
	public Set getRoleUsers();
}